/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyClassForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyInterfaceForTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class DynamicWebContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    public abstract ArchivePath getWebPath();

    public abstract ArchivePath getWebInfPath();

    public abstract WebContainer<T> getWebContainer();

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLResource() {
        this.getWebContainer().setWebXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLResourceInPackage() {
        this.getWebContainer().setWebXML(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLFile() throws Exception {
        this.getWebContainer().setWebXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLURL() {
        this.getWebContainer().setWebXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLAsset() {
        this.getWebContainer().setWebXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceResource() {
        this.getWebContainer().addAsWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceFile() throws Exception {
        this.getWebContainer().addAsWebResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getWebContainer().addAsWebResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getWebPath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetResource() {
        this.getWebContainer().addAsWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetFile() throws Exception {
        this.getWebContainer().addAsWebResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetURL() {
        this.getWebContainer().addAsWebResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetAsset() {
        this.getWebContainer().addAsWebResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetResource() {
        this.getWebContainer().addAsWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetFile() throws Exception {
        this.getWebContainer().addAsWebResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetURL() {
        this.getWebContainer().addAsWebResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetAsset() {
        this.getWebContainer().addAsWebResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackage() {
        this.getWebContainer().addAsWebResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getWebPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackages() {
        this.getWebContainer().addAsWebResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getWebPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getWebPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackageStringTarget() {
        this.getWebContainer().addAsWebResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackagePathTarget() {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getWebContainer().addAsWebResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getWebPath(), targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceResource() {
        this.getWebContainer().addAsWebInfResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceFile() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getWebContainer().addAsWebInfResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getWebInfPath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetResource() {
        this.getWebContainer().addAsWebInfResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetFile() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetURL() {
        this.getWebContainer().addAsWebInfResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetAsset() {
        this.getWebContainer().addAsWebInfResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetResource() {
        this.getWebContainer().addAsWebInfResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetFile() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetURL() {
        this.getWebContainer().addAsWebInfResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetAsset() {
        this.getWebContainer().addAsWebInfResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackage() {
        this.getWebContainer().addAsWebInfResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackages() {
        this.getWebContainer().addAsWebInfResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getWebInfPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackageStringTarget() {
        this.getWebContainer().addAsWebInfResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackagePathTarget() {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getWebContainer().addAsWebInfResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getWebInfPath(), targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebStringTargetResourceFromJar() {
        this.getWebContainer().addAsWebResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getWebPath(), "String.class");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfStringTargetResourceFromJar() {
        this.getWebContainer().addAsWebInfResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "String.class");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void canDeleteEmbeddedArchiveAddedAsLibrary() {
        String name = "test.jar";
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries(new Archive[]{((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)name)).add((Asset)EmptyAsset.INSTANCE, "some")});
        ArchivePath path = ArchivePaths.create((String)"WEB-INF/lib", (String)name);
        Assertions.assertTrue((boolean)war.contains(path));
        war.delete(path);
        Assertions.assertFalse((boolean)war.contains(path), (String)"Path should have been deleted");
    }

    @Override
    @Test
    public void testAddServiceProvider() {
        ServiceProviderPathExposingWebArchive webArchive = new ServiceProviderPathExposingWebArchive((Archive)ShrinkWrap.create(WebArchive.class));
        webArchive.addAsServiceProvider(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        ArchivePath testPath = webArchive.getServiceProvidersPath();
        Assertions.assertTrue((boolean)webArchive.contains(testPath), (String)("Archive should contain " + testPath));
        testPath = new BasicPath(webArchive.getServiceProvidersPath(), DummyInterfaceForTest.class.getName());
        Assertions.assertTrue((boolean)webArchive.contains(testPath), (String)("Archive should contain " + testPath));
    }

    @Override
    @Test
    public void testAddServiceProviderString() throws Exception {
        String serviceInterface = "do.not.exist.api.Dummy";
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        ServiceProviderPathExposingWebArchive webArchive = new ServiceProviderPathExposingWebArchive((Archive)ShrinkWrap.create(WebArchive.class));
        webArchive.addAsServiceProvider(serviceInterface, impls);
        BasicPath testPath = new BasicPath(webArchive.getServiceProvidersPath(), "/do.not.exist.api.Dummy");
        Assertions.assertTrue((boolean)webArchive.contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        this.assertServiceProviderContent(webArchive.get((ArchivePath)testPath), impls);
    }

    @Override
    @Test
    public void testAddServiceProviderStringInterfaceValidation() {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            WebArchive cfr_ignored_0 = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider(null, impls);
        });
    }

    @Override
    @Test
    public void testAddServiceProviderStringImplementationsValidation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            WebArchive cfr_ignored_0 = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider("do.not.exist.impl.Dummy", (String[])null);
        });
    }

    @Override
    @Test
    public void testAddServiceProviderStringImplementationsValueValidation() {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", null};
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            WebArchive cfr_ignored_0 = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider("do.not.exist.impl.Dummy", impls);
        });
    }

    @Override
    @Test
    @ArchiveType(value=ServiceProviderContainer.class)
    public void testAddServiceProviderWithClasses() {
        Class[] expectedResources;
        ServiceProviderPathExposingWebArchive webArchive = new ServiceProviderPathExposingWebArchive((Archive)ShrinkWrap.create(WebArchive.class));
        webArchive.addAsServiceProviderAndClasses(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        ArchivePath testPath = webArchive.getServiceProvidersPath();
        Assertions.assertTrue((boolean)webArchive.contains(testPath), (String)("Archive should contain " + testPath));
        testPath = new BasicPath(webArchive.getServiceProvidersPath(), DummyInterfaceForTest.class.getName());
        Assertions.assertTrue((boolean)webArchive.contains(testPath), (String)("Archive should contain " + testPath));
        for (Class expectedResource : expectedResources = new Class[]{DummyInterfaceForTest.class, DummyClassForTest.class}) {
            BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((Class)expectedResource));
            Assertions.assertTrue((boolean)webArchive.contains((ArchivePath)expectedClassPath), (String)("Archive should contain " + testPath));
        }
    }

    private class ServiceProviderPathExposingWebArchive
    extends WebArchiveImpl {
        private ServiceProviderPathExposingWebArchive(Archive<?> delegate) {
            super(delegate);
        }

        public ArchivePath getServiceProvidersPath() {
            return super.getServiceProvidersPath();
        }
    }
}

