/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.unit;

import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.jboss.shrinkwrap.spi.MemoryMapArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MemoryMapArchiveTestCase
extends ArchiveTestBase<MemoryMapArchive> {
    private MemoryMapArchive archive;

    @BeforeEach
    public void createArchive() {
        this.archive = this.createNewArchive();
        this.archive.toString(false);
    }

    protected MemoryMapArchive createNewArchive() {
        return new MemoryMapArchiveImpl(ShrinkWrap.getDefaultDomain().getConfiguration());
    }

    @Override
    protected MemoryMapArchive getArchive() {
        return this.archive;
    }

    @Test
    public void testConstructorWithName() {
        String name = "test.jar";
        MemoryMapArchiveImpl tmp = new MemoryMapArchiveImpl(name, ShrinkWrap.getDefaultDomain().getConfiguration());
        Assertions.assertEquals((Object)name, (Object)tmp.getName(), (String)"Should return the same name as constructor arg");
    }

    @Test
    public void testConstructorRequiresName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MemoryMapArchiveImpl(null));
    }

    @Test
    public void testConstructorRequiresExtensionLoader() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MemoryMapArchiveImpl("test.jar", null));
    }

    @Override
    protected ArchiveFormat getExpectedArchiveFormat() {
        return ArchiveFormat.UNKNOWN;
    }
}

