/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.support;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.jboss.annotation.spring.Spring;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public abstract class SpringInjectionSupport {
    protected Logger log = Logger.getLogger(this.getClass());
    private final Comparator<Method> METHOD_COMPARATOR = new MethodComparator();

    protected Object inject(Object target) throws Exception {
        Field[] fields;
        Method[] methods;
        this.log.debug((Object)("Invoking Spring injection: " + target.getClass().getName()));
        for (Method m : methods = this.getAllMethods(target)) {
            Spring spring = m.getAnnotation(Spring.class);
            if (spring == null) continue;
            if (this.isSetterMethod(m)) {
                this.injectToMethod(target, m, spring);
                continue;
            }
            this.log.warn((Object)"Spring annotation only allowed on setter methods.");
        }
        for (Field f : fields = this.getAllFields(target)) {
            Spring spring = f.getAnnotation(Spring.class);
            if (spring == null) continue;
            this.injectToField(target, f, spring);
        }
        return target;
    }

    protected Method[] getAllMethods(Object bean) {
        TreeSet<Method> methods = new TreeSet<Method>(this.METHOD_COMPARATOR);
        for (Class<?> beanClass = bean.getClass(); beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
            methods.addAll(Arrays.asList(beanClass.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    protected Field[] getAllFields(Object bean) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> beanClass = bean.getClass(); beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
            fields.addAll(Arrays.asList(beanClass.getDeclaredFields()));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private boolean isSetterMethod(Method m) {
        return m.getName().startsWith("set") && m.getParameterTypes().length == 1;
    }

    protected String getJndiName(String jndiName) {
        if (jndiName == null || jndiName.length() == 0) {
            throw new IllegalArgumentException("Empty BeanFactory jndi name.");
        }
        return jndiName;
    }

    private Object getObjectFromBeanFactory(Spring spring, String defaultBeanName, Class beanType) throws Exception {
        BeanFactory beanFactory = (BeanFactory)Util.lookup((String)this.getJndiName(spring.jndiName()), BeanFactory.class);
        String beanName = spring.bean();
        if (beanName != null && beanName.length() > 0) {
            return beanFactory.getBean(beanName, beanType);
        }
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            Map beans = lbf.getBeansOfType(beanType);
            if (beans.size() > 1) {
                Object bean = beans.get(defaultBeanName);
                if (bean == null) {
                    throw new IllegalArgumentException("More than one bean of type: " + beanType);
                }
                return bean;
            }
            if (beans.size() == 1) {
                return beans.values().iterator().next();
            }
            throw new IllegalArgumentException("No such bean by type: " + beanType);
        }
        return beanFactory.getBean(defaultBeanName, beanType);
    }

    private void injectToMethod(Object target, Method method, Spring spring) throws Exception {
        String defaultBeanName = this.getDefaultBeanName(method);
        Object bean = this.getObjectFromBeanFactory(spring, defaultBeanName, method.getParameterTypes()[0]);
        this.logInjection(spring, bean, target, method);
        method.setAccessible(true);
        method.invoke(target, bean);
    }

    protected String getDefaultBeanName(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getName().substring(3, 3).toLowerCase());
        buffer.append(method.getName().substring(4));
        return buffer.toString();
    }

    private void injectToField(Object target, Field field, Spring spring) throws Exception {
        String defaultBeanName = this.getDefaultBeanName(field);
        Object bean = this.getObjectFromBeanFactory(spring, defaultBeanName, field.getType());
        this.logInjection(spring, bean, target, field);
        field.setAccessible(true);
        field.set(target, bean);
    }

    protected String getDefaultBeanName(Field field) {
        return field.getName();
    }

    private void logInjection(Spring spring, Object bean, Object target, Member m) {
        this.log.debug((Object)("Injecting bean '" + spring.bean() + "' of class type " + bean.getClass().getName() + " into " + target + " via " + m));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method m1, Method m2) {
            String name2;
            String name1 = m1.getName();
            if (name1.equals(name2 = m2.getName())) {
                Class<?>[] params2;
                Class<?> returnType1 = m1.getReturnType();
                Class<?> returnType2 = m2.getReturnType();
                Class<?>[] params1 = m1.getParameterTypes();
                if (params1.length == (params2 = m1.getParameterTypes()).length) {
                    if (returnType1.equals(returnType2)) {
                        int i;
                        int length = params1.length;
                        for (i = 0; i < length && params1[i].equals(params2[i]); ++i) {
                        }
                        if (i < length) {
                            return params1[i].getName().compareTo(params2[i].getName());
                        }
                        if (m1.getAnnotation(Spring.class) != null) {
                            SpringInjectionSupport.this.log.warn((Object)("Found overridden @Spring annotated method: " + m1));
                        }
                        return 0;
                    }
                    return returnType1.getName().compareTo(returnType2.getName());
                }
                return params1.length - params2.length;
            }
            return name1.compareTo(name2);
        }
    }
}

