/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.spring.factory;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.Resource;

/**
 * @author <a href="mailto:ales.justin@genera-lynx.com">Ales Justin</a>
 */
public class NamedXmlBeanFactory extends DefaultListableBeanFactory implements Nameable, Instantiable {

    private String defaultName;

    private final NamedXmlBeanDefinitionReader reader = new NamedXmlBeanDefinitionReader(this);

    /**
     * @param defaultName the default name
     * @param resource    the resource
     * @throws BeansException for any exception
     * @see org.springframework.beans.factory.xml.XmlBeanFactory
     */
    public NamedXmlBeanFactory(String defaultName, Resource resource) throws BeansException {
        this.reader.loadBeanDefinitions(resource);
        this.defaultName = defaultName;
    }

    public String getName() {
        String name = reader.getName() != null ? reader.getName() : defaultName;
        if (name == null) {
            throw new IllegalArgumentException("Bean factory JNDI name must be set!");
        }
        return name;
    }

    public boolean doInstantiate() {
        return reader.doInstantiate();
    }
}
