/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.factory;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jboss.spring.factory.Nameable;
import org.jboss.spring.vfs.context.VFSClassPathXmlApplicationContext;
import org.jboss.util.naming.Util;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

public class NamedXmlApplicationContext
extends VFSClassPathXmlApplicationContext
implements Nameable {
    private String defaultName;
    private String name;
    private Resource resource;

    public NamedXmlApplicationContext(String defaultName, Resource resource) throws BeansException {
        this(defaultName, resource, true);
    }

    public NamedXmlApplicationContext(String defaultName, Resource resource, boolean refresh) throws BeansException {
        super(new String[0], false);
        this.defaultName = defaultName;
        this.resource = resource;
        this.initializeNames(resource);
        if (refresh) {
            this.refresh();
        }
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        reader.loadBeanDefinitions(this.resource);
    }

    @Override
    public String getName() {
        String name;
        String string = name = this.name != null ? this.name : this.defaultName;
        if (name == null) {
            throw new IllegalArgumentException("Bean factory JNDI name must be set!");
        }
        return name;
    }

    private void initializeNames(Resource resource) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    return "http://www.springframework.org/schema/beans";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return "beans";
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    return Collections.singleton("beans").iterator();
                }
            });
            String expression = "/beans:beans/beans:description";
            InputSource inputSource = new InputSource(resource.getInputStream());
            String description = xPath.evaluate(expression, inputSource);
            if (description != null) {
                Matcher pbfm;
                Matcher bfm = Pattern.compile("BeanFactory=\\(([^)]+)\\)").matcher(description);
                if (bfm.find()) {
                    this.name = bfm.group(1);
                }
                if ((pbfm = Pattern.compile("ParentBeanFactory=\\(([^)]+)\\)").matcher(description)).find()) {
                    String parentName = pbfm.group(1);
                    try {
                        this.getBeanFactory().setParentBeanFactory((BeanFactory)Util.lookup((String)parentName, BeanFactory.class));
                    }
                    catch (Exception e) {
                        throw new BeanDefinitionStoreException("Failure during parent bean factory JNDI lookup: " + parentName, (Throwable)e);
                    }
                }
            }
            if (this.name == null || "".equals(StringUtils.trimAllWhitespace((String)this.name))) {
                this.name = this.defaultName;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

