/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.instrument.classloading;

import java.lang.reflect.Method;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderSystem;
import org.jboss.instrument.classloading.JBoss5ClassLoader;
import org.jboss.util.loading.Translator;

public class JBoss50ClassLoader
extends JBoss5ClassLoader {
    private Method addTranslator;
    private ClassLoaderSystem system;

    public JBoss50ClassLoader(BaseClassLoader classLoader) {
        super(classLoader);
    }

    protected void fallbackStrategy() throws Exception {
        try {
            this.addTranslator = JBoss50ClassLoader.getMethod(BaseClassLoaderPolicy.class, "addTranslator");
        }
        catch (Exception ignored) {
            this.log.info((Object)"Policy doesn't have addTranslator, falling back to ClassLoaderSystem.");
            Method getClassLoaderDomain = JBoss50ClassLoader.getMethod(BaseClassLoaderPolicy.class, "getClassLoaderDomain");
            BaseClassLoaderDomain domain = JBoss50ClassLoader.invokeMethod(getClassLoaderDomain, this.getPolicy(), BaseClassLoaderDomain.class);
            Method getClassLoaderSystem = JBoss50ClassLoader.getMethod(BaseClassLoaderDomain.class, "getClassLoaderSystem");
            BaseClassLoaderSystem system = JBoss50ClassLoader.invokeMethod(getClassLoaderSystem, domain, BaseClassLoaderSystem.class);
            if (system instanceof ClassLoaderSystem) {
                this.system = (ClassLoaderSystem)ClassLoaderSystem.class.cast(system);
            }
            throw new IllegalArgumentException("ClassLoaderSyatem must be instance of [" + ClassLoaderSystem.class.getName() + "]");
        }
    }

    protected void addTranslator(Translator translator) {
        if (this.addTranslator != null) {
            try {
                this.addTranslator.invoke((Object)translator, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.system.setTranslator(translator);
        }
    }
}

