/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;

import javax.xml.soap.SOAPMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 * @author Jeff Yu <cyu@redhat.com>
 */
public class JavaUtils
{ 
  protected static final Log log = LogFactory.getLog(JavaUtils.class);
	
  public static boolean isJBossRepositoryClassLoader(ClassLoader loader)
  {
    Class clazz = loader.getClass();
    while (!clazz.getName().startsWith("java"))
    {
      if ("org.jboss.mx.loading.RepositoryClassLoader".equals(clazz.getName()))
        return true;
      clazz = clazz.getSuperclass();
    }

    return false;
  }

  /**
   * Clears black lists on a JBoss RepositoryClassLoader. This is somewhat of a hack, and
   * could be replaced with an integration module. This is needed when the following order of
   * events occur.
   *
   * <ol>
   *   <li>loadClass() returns not found</li>
   *   <li>Some call to defineClass()</li>
   * <ol>
   *
   * The CNFE triggers a black list addition, which cause the class never again to be found.
   *
   * @param loader the loader to clear black lists for
   */
  public static void clearBlacklists(ClassLoader loader)
  {
    if (isJBossRepositoryClassLoader(loader))
    {
      for(Method m : loader.getClass().getMethods())
      {
        if("clearBlackLists".equalsIgnoreCase(m.getName()))
        {
          try
          {
            m.invoke(loader);
          }
          catch (Exception e)
          {
            e.printStackTrace();
          }
        }
      }
    }
  }
  
  /**
   * Convert the SoapMessage object into String.
   * @param soapMessage
   * @return
   */
  public static String getSoapMessageASString(SOAPMessage soapMessage) {
   try {
		  ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		  soapMessage.writeTo(outputStream);
		  byte[] byteArray = outputStream.toByteArray();
		  String soapMsg = new String( byteArray, "UTF-8");
		  return soapMsg;
	} catch (Exception e) {
		log.error("Error in converting SOAPMessage into String");
	}
	return null;
  }
}
