/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;

/**
 * @author Heiko Braun <hbraun@redhat.com>
 */
public class MessageContext
{  
  private SOAPMessage message;
  private QName serviceName;
  private String portName;
  private Definition wsdlDefinition;

  protected MessageContext()
  {
  }

  public void setMessage(SOAPMessage message)
  {
    this.message = message;
  }

  public SOAPMessage getMessage()
  {
    return message;
  }

  public QName getServiceName()
  {
    return serviceName;
  }

  public void setServiceName(QName serviceName)
  {
    this.serviceName = serviceName;
  }

  public String getPortName()
  {
    return portName;
  }

  public void setPortName(String portName)
  {
    this.portName = portName;
  }

  public void setWsdlDefinition(Definition wsdlDefinition)
  {
    this.wsdlDefinition = wsdlDefinition;
  }

  public Definition getWsdlDefinition()
  {
    return wsdlDefinition;
  }
}
