/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.actions.bpel;

import org.jboss.internal.soa.esb.actions.bpel.ESBInvocationAdapter;
import org.jboss.soa.bpel.runtime.engine.BPELEngine;

import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import javax.xml.namespace.QName;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class TestBPELEngine implements BPELEngine {

	public TestBPELEngine() {
	}
	
	public TestBPELEngine(Element resp) {
		m_response = resp;
	}

	public TestBPELEngine(QName faultName, Element faultResp) {
		m_response = faultResp;
		m_faultName = faultName;
	}

	public TestBPELEngine(String resp) throws Exception {
		DocumentBuilder builder=DocumentBuilderFactory.newInstance().newDocumentBuilder();
		
		java.io.InputStream is=new java.io.ByteArrayInputStream(resp.toString().getBytes());
		
		Document doc=builder.parse(is);
		
		is.close();
		
		m_response = doc.getDocumentElement();
	}

	public void close() throws Exception {
		// TODO Auto-generated method stub
		
	}

	public void init() throws Exception {
		// TODO Auto-generated method stub
		
	}

  public void invoke(InvocationAdapter invocationAdapter)
			throws Exception {
		
	  ESBInvocationAdapter esbCtx = (ESBInvocationAdapter) invocationAdapter;
	  m_request = esbCtx.getRequestXML();
	  esbCtx.setResponseXML(m_response);
	  esbCtx.setFaultName(m_faultName);
	}

	public Element getRequest() {
		return(m_request);
	}


	public Object getManagementInterface() {
		throw new RuntimeException("Not implemented");
	}
	
	private Element m_request=null;
	private Element m_response=null;
	private QName m_faultName=null;
}
