/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.esb.quickstarts.bpel;

import org.jboss.bpel.samples.ordermanagement.*;

import javax.jws.WebService;
import javax.jws.WebMethod;
import javax.jws.soap.SOAPBinding;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.rmi.RemoteException;
import java.util.Map;

/**
 * Order Manager Service wrapper webservice.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@WebService(name = "OrderManagerPortType", targetNamespace = OrderManagerService.Namespace)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, parameterStyle = SOAPBinding.ParameterStyle.BARE)
public class OrderManagerService implements OrderManager {

    public static final String Namespace = "http://org.jboss.esb/quickstarts/bpel/ABI_OrderManager";

    private OrderManager orderManagement = null;

    public OrderManagerService() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        } catch (NamingException e) {
            throw new RuntimeException("Unable to create JNDI context.", e);
        }
        try {
            orderManagement = (OrderManager) ctx.lookup("OrderManagerBean/remote");
        } catch (NamingException e) {
            throw new RuntimeException("Unable to lookup OrderManager Service Bean.", e);
        }
    }

    @WebMethod(operationName = "customerOrder")
    public String createSalesOrder(CustomerOrder customerOrder) throws SalesOrderFault, RemoteException {
        return orderManagement.createSalesOrder(customerOrder);
    }

    @WebMethod(operationName = "cancelOrder")
    public boolean cancelOrder(CancelOrder cancelOrder) throws RemoteException {
        System.out.println("cancelOrder.getOrderInquiry(): " + cancelOrder.getOrderInquiry());
        return orderManagement.cancelOrder(cancelOrder);
    }

    public Map<String, CustomerOrder> getOrders() throws RemoteException {
        throw new UnsupportedOperationException("Not exposed as a SOAP operation.");
    }

    public boolean approveOrder(String orderNumber) throws RemoteException {
        throw new UnsupportedOperationException("Not exposed as a SOAP operation.");
    }
}
