/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_loan_approval sample.
 */
public class QuickstartBPELLoanApprovalTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_bpel_loan_approval";

	public QuickstartBPELLoanApprovalTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(QuickstartBPELLoanApprovalTestCase.class,
						TEST_NAME, "Quickstart_bpel_loan_approval.war,Quickstart_bpel_loan_approval-1.jar"));
	}

	public void testSendLoanRequest1() throws Exception {
		String result=sendSOAPMessage("loanreq1.xml",
					"http://localhost:8080/Quickstart_bpel_loan_approvalWS");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "loanresp1.xml");
	}

	public void testSendLoanRequest2() throws Exception {
		String result=sendSOAPMessage("loanreq2.xml",
					"http://localhost:8080/Quickstart_bpel_loan_approvalWS");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "loanresp2.xml");
	}

	public void testSendLoanRequest3() throws Exception {
		String result=sendSOAPMessage("loanreq3.xml",
					"http://localhost:8080/Quickstart_bpel_loan_approvalWS");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			assertMessageFromFile(result, "loanresp3-cxf.xml");
		} else {
			assertMessageFromFile(result, "loanresp3-native.xml");
		}
	}
	
	public void testSendLoanRequest4() throws Exception {
		String result=sendSOAPMessage("loanreq4.xml",
					"http://localhost:8080/Quickstart_bpel_loan_approvalWS");
	
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			assertMessageFromFile(result, "loanresp4-cxf.xml");
		} else {
			assertMessageFromFile(result, "loanresp4-native.xml");
		}
	}
}
