package org.jboss.soa.bpel.tests.tutorials.BluePrint2;

import junit.framework.Test;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

public class BluePrint2TestCase extends RiftSawTest {

	private static final String TEST_NAME = "BluePrint2";

	public BluePrint2TestCase() {
		super(TEST_NAME);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(BluePrint2TestCase.class,
						TEST_NAME, "BluePrint2-1.jar"));
	}

	public void testSendValid() throws Exception {
		String result=sendSOAPMessage("valid.xml",
					"http://localhost:8080/BPEL_BluePrint2_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "valid_response.xml");
	}

	public void testSendInvalid() throws Exception {
		String result=sendSOAPMessage("invalid.xml",
					"http://localhost:8080/BPEL_BluePrint2_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
			result = result.replaceAll("<env:Fault>","<env:Fault xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>");
			result = result.replaceAll("ns0","valueNS");
			result = result.replaceAll("<faultstring>Fault string, and possibly fault code, not set</faultstring>","");
		}
		
		assertMessageFromFile(result, "invalid_response.xml");
	}

	public void testSendTimeout() throws Exception {
		String result=sendSOAPMessage("timeout.xml",
					"http://localhost:8080/BPEL_BluePrint2_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
			result = result.replaceAll("<env:Fault>","<env:Fault xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>");
			result = result.replaceAll("ns0","valueNS");
			result = result.replaceAll("<faultstring>Fault string, and possibly fault code, not set</faultstring>","");
		}
		
		assertMessageFromFile(result, "timeout_response.xml");
	}

}
