package org.jboss.soa.bpel.tests.tutorials.BluePrint3;

import junit.framework.Test;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

public class BluePrint3TestCase extends RiftSawTest {

	private static final String TEST_NAME = "BluePrint3";

	public BluePrint3TestCase() {
		super(TEST_NAME);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(BluePrint3TestCase.class,
						TEST_NAME, "BluePrint3-1.jar"));
	}

	public void testSendValid() throws Exception {
		String result=sendSOAPMessage("valid.xml",
					"http://localhost:8080/BPEL_BluePrint3_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "valid_response.xml");
	}

	public void testSendInvalid() throws Exception {
		String result=sendSOAPMessage("invalid.xml",
					"http://localhost:8080/BPEL_BluePrint3_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
			result = result.replaceAll("<env:Fault>","<env:Fault xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>");
			result = result.replaceAll("ns0","valueNS");
			result = result.replaceAll("<faultstring>Fault string, and possibly fault code, not set</faultstring>","");
		}
		
		assertMessageFromFile(result, "invalid_response.xml");
	}

	public void testSendThrowPOFault() throws Exception {
		String result=sendSOAPMessage("throw_po_fault.xml",
					"http://localhost:8080/BPEL_BluePrint3_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
			result = result.replaceAll("<env:Fault>","<env:Fault xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>");
			result = result.replaceAll("ns0","valueNS");
			result = result.replaceAll("<faultstring>Fault string, and possibly fault code, not set</faultstring>","");
		}
		
		assertMessageFromFile(result, "throw_po_fault_response.xml");
	}

	public void testSendThrowInvFault() throws Exception {
		String result=sendSOAPMessage("throw_inv_fault.xml",
					"http://localhost:8080/BPEL_BluePrint3_PurchaseOrderService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
			result = result.replaceAll("<env:Fault>","<env:Fault xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'>");
			result = result.replaceAll("ns0","valueNS");
			result = result.replaceAll("<faultstring>Fault string, and possibly fault code, not set</faultstring>","");
			result = result.replaceAll("<tns:FaultCode xmlns:tns='http://manufacturing.org/xsd/inventory' />","<tns:FaultCode xmlns:tns='http://manufacturing.org/xsd/inventory'/>");
		}
		
		assertMessageFromFile(result, "throw_inv_fault_response.xml");
	}

}
