package org.jboss.soa.bpel.tests.tutorials.BluePrint5;

import junit.framework.Test;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

public class BluePrint5TestCase extends RiftSawTest {

	private static final String TEST_NAME = "BluePrint5";

	public BluePrint5TestCase() {
		super(TEST_NAME);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(BluePrint5TestCase.class,
						TEST_NAME, "BluePrint5-1.jar"));
	}

	public void testSendBookAirline() throws Exception {
		String result=sendSOAPMessage("book_airline.xml",
					"http://localhost:8080/BPEL_BluePrint5_ReservationService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "book_airline_response.xml");
	}

	public void testSendBookCar() throws Exception {
		String result=sendSOAPMessage("book_car.xml",
					"http://localhost:8080/BPEL_BluePrint5_ReservationService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "book_car_response.xml");
	}

	public void testSendBookHotel() throws Exception {
		String result=sendSOAPMessage("book_hotel.xml",
					"http://localhost:8080/BPEL_BluePrint5_ReservationService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "book_hotel_response.xml");
	}

	public void testSendBookAll() throws Exception {
		String result=sendSOAPMessage("book_all.xml",
					"http://localhost:8080/BPEL_BluePrint5_ReservationService");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "book_all_response.xml");
	}

}
