/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.net.URL;
import java.net.URLClassLoader;

import javax.xml.namespace.QName;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;

/**
 * This class implements the JAXWSInitializer interface to
 * provide Apache CXF specific initialization.
 * 
 * @author gbrown
 *
 */
public class CXFJAXWSInitializer implements JAXWSInitializer {
	
	protected final Log log = LogFactory.getLog(getClass());
	
	/**
	 * This method initializes the web service stack in preparation for
	 * calling the service and port supplied as parameters.
	 * 
	 * @param serviceName The service name
	 * @param portName The port name
	 * @param baseURI The base URI of the deployment
	 */
	public void initializeStack(QName serviceName, QName portName, java.net.URI baseURI) {
		try {
			SpringBusFactory bf = new SpringBusFactory();
		      
			URLClassLoader urlcl=new URLClassLoader(new URL[]{baseURI.toURL()});
			
			String filename="jbossws-cxf-"+portName.getLocalPart()+".xml";
		      
			URL busFile = urlcl.getResource(filename);
			
			log.debug("Web Stack initialization file: name="+filename+" file="+busFile);
			
			if (busFile != null) {
				Bus bus = bf.createBus(busFile.toString());
				bf.setThreadDefaultBus(bus);
				
				log.debug("Set thread default bus="+bus);
			}
		      	
		} catch(Exception e) {
			log.error("Failed to initialize WS-Security in stack", e);
		}
	}
}
