/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.xml.namespace.QName;

/**
 * Minimum endpoint meta data that's required to create
 * endpoints. Anything else is derived by the {@link org.jboss.soa.bpel.runtime.ws.EndpointManager}
 * itself.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class EndpointMetaData
{
  private QName serviceName;
  private String portName;
  private String endpointId;
  private QName processId;
  
  public EndpointMetaData(QName serviceName, String portName, QName processId, String endpointId)
  {
    this.serviceName = serviceName;
    this.portName = portName;
    this.processId = processId;
    this.endpointId = endpointId;
  }

  public QName getServiceName()
  {
    return serviceName;
  }

  public String getPortName()
  {
    return portName;
  }

  public QName getProcessId()
  {
    return processId;
  }

  public String getEndpointId()
  {
    return endpointId;
  }

  public void setEndpointId(String endpointId)
  {
    this.endpointId = endpointId;
  }
}
