/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.esb.quickstarts.bpel.transforms;

import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.container.ExecutionContext;
import org.milyn.SmooksException;
import org.milyn.xml.DomUtils;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksConfigurationException;
import org.w3c.dom.Element;
import org.jboss.esb.quickstarts.bpel.OrderManagerService;

/**
 * <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class OrderNumNSModifier implements DOMVisitAfter {

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        Element newOrderNumElement = element.getOwnerDocument().createElementNS(OrderManagerService.Namespace, "ord_manager:orderNumber");

        newOrderNumElement.setTextContent(element.getTextContent());
        newOrderNumElement.setAttribute("xmlns:ord_manager", OrderManagerService.Namespace);

        System.out.println("**** Fixing up the Order Manager namespace on the orderNumber element.");
        DomUtils.replaceNode(newOrderNumElement, element);
    }
}
