/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests;

import java.io.Serializable;
import java.net.URL;
import java.security.Principal;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
*/

/**
 * A JBossWS test helper that deals with test deployment/undeployment, etc.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 14-Oct-2004
 */
public class TestDeployerJBoss implements TestDeployer {
   private static final String MAIN_DEPLOYER = "jboss.system:service=MainDeployer";

   private MBeanServerConnection server;

   public TestDeployerJBoss(MBeanServerConnection server) {
      this.server = server;
   }

   public void deploy(URL url) throws Exception
   {
      invokeMainDeployer("deploy", url);
   }

   public void undeploy(URL url) throws Exception
   {
      invokeMainDeployer("undeploy", url);
   }

   private void invokeMainDeployer(String methodName, URL url) throws Exception {
    	 //System.out.println("INVOKE MAIN DEPLOYER: "+methodName+" URL="+url);
         server.invoke(new ObjectName(MAIN_DEPLOYER), methodName, new Object[] { url }, new String[] { "java.net.URL" });
   }
}
