/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_loan_approval sample from an ESB service.
 */
public class QuickstartBPELInvokeESBEBWSTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_bpel_approval_service";

	public QuickstartBPELInvokeESBEBWSTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		if (System.getProperty("ws.stack","native").equals("native")) {
			return(new RiftSawTestSetup(QuickstartBPELInvokeESBEBWSTestCase.class,
						TEST_NAME, "CreditAgency.esb,Quickstart_bpel_approval_service-1.jar"));
		} else {
			return(null);
		}
	}

	public void testSendHello() throws Exception {
		if (System.getProperty("ws.stack","native").equals("native") == false) {
			return;
		}

		String result=sendSOAPMessage("approve_request1.xml",
					"http://localhost:8080/Quickstart_bpel_approval_serviceWS");
		
		// If testing against cxf, then result is presented slightly differently
		if (result.indexOf("SOAP-ENV") != -1) {
			result = result.replaceAll("SOAP-ENV", "env");
			result = result.replaceAll(" xmlns=\"\"","");
			result = result.replaceAll("\"","'");
			result = result.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result, "approve_response1.xml");
	}
}
