/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_simple_pick sample.
 */
public class QuickstartBPELSimplePickTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_bpel_simple_pick";

	public QuickstartBPELSimplePickTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(QuickstartBPELSimplePickTestCase.class,
						TEST_NAME, "Quickstart_bpel_simple_pick-1.jar"));
	}

	public void testSendHelloHello() throws Exception {
		String result1=sendSOAPMessage("hello_request1.xml",
				"http://localhost:8080/Quickstart_bpel_simple_pickWS");

		// If testing against cxf, then result is presented slightly differently
		if (result1.indexOf("SOAP-ENV") != -1) {
			result1 = result1.replaceAll("SOAP-ENV", "env");
			result1 = result1.replaceAll(" xmlns=\"\"","");
			result1 = result1.replaceAll("\"","'");
			result1 = result1.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result1, "hello_response1.xml");
		
		String result2=sendSOAPMessage("hello_request1.xml",
				"http://localhost:8080/Quickstart_bpel_simple_pickWS");
		
		// If testing against cxf, then result is presented slightly differently
		if (result2.indexOf("SOAP-ENV") != -1) {
			result2 = result2.replaceAll("SOAP-ENV", "env");
			result2 = result2.replaceAll(" xmlns=\"\"","");
			result2 = result2.replaceAll("\"","'");
			result2 = result2.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result2, "hello_response1.xml");
	}

	public void testSendGoodbyeHello() throws Exception {
		String result1=sendSOAPMessage("goodbye_request1.xml",
				"http://localhost:8080/Quickstart_bpel_simple_pickWS");
		
		// If testing against cxf, then result is presented slightly differently
		if (result1.indexOf("SOAP-ENV") != -1) {
			result1 = result1.replaceAll("SOAP-ENV", "env");
			result1 = result1.replaceAll(" xmlns=\"\"","");
			result1 = result1.replaceAll("\"","'");
			result1 = result1.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result1, "goodbye_response1.xml");

		String result2=sendSOAPMessage("hello_request1.xml",
				"http://localhost:8080/Quickstart_bpel_simple_pickWS");

		// If testing against cxf, then result is presented slightly differently
		if (result2.indexOf("SOAP-ENV") != -1) {
			result2 = result2.replaceAll("SOAP-ENV", "env");
			result2 = result2.replaceAll(" xmlns=\"\"","");
			result2 = result2.replaceAll("\"","'");
			result2 = result2.replaceAll("<env:Header />","<env:Header></env:Header>");
		}
		
		assertMessageFromFile(result2, "hello_response1.xml");
	}
}
