/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_hello_world_no_extended_timeout sample.
 */
public class QuickstartESBBPELHelloWorldNoExtendedTimeoutTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_esb_bpel_hello_world_no_extended_timeout";

	public QuickstartESBBPELHelloWorldNoExtendedTimeoutTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(QuickstartESBBPELHelloWorldNoExtendedTimeoutTestCase.class,
						TEST_NAME, "Quickstart_esb_bpel_hello_world_no_extended_timeout.esb,../Quickstart_bpel_hello_world_extended_timeout/Quickstart_bpel_hello_world_extended_timeout-1.jar"));
	}

	public void testSendHello() throws Exception {
		
		try {
			sendESBMessage("Hello World via ESB to BPEL", "HelloWorldBPELESB", "SayHello", 180000);
			
			fail("Should have timed out due to default timeout period on BPEL process");
		} catch(Exception e) {
			// Ignore - should fail due to timeout
		}
	}
}
