package org.jboss.soa.bpel.tests.samples.atm;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

@WebServiceClient(name = AtmService.SERVICE_NAME, targetNamespace = AtmService.TARGET_NAMESPACE, wsdlLocation = AtmService.WSDL_LOCATION)
public class AtmService extends Service {

	public static final String SERVICE_NAME = "AtmService";
	public static final String TARGET_NAMESPACE = "http://jbpm.org/examples/atm";
	public static final String WSDL_LOCATION =
			"http://127.0.0.1:8080/Tutorial_bpel_atm_frontEnd?wsdl";
	public static final String FRONT_END_PORT_NAME = "FrontEndPort";

	private static final URL WSDL_URL = createURL(WSDL_LOCATION);
	private static final QName SERVICE_QNAME =
			new QName(TARGET_NAMESPACE, SERVICE_NAME);
	private static final QName FRONT_END_PORT_QNAME =
			new QName(TARGET_NAMESPACE, FRONT_END_PORT_NAME);

	private static URL createURL(String location) {
		try {
			return new URL(location);
		}
		catch (MalformedURLException e) {
			throw new IllegalArgumentException(location, e);
		}
	}

	public AtmService(URL wsdlLocation, QName serviceName) {
		super(wsdlLocation, serviceName);
	}

	public AtmService() {
		super(WSDL_URL, SERVICE_QNAME);
	}

	@WebEndpoint(name = FRONT_END_PORT_NAME)
	public FrontEnd getFrontEndPort() {
		return getPort(FRONT_END_PORT_QNAME, FrontEnd.class);
	}

	/**
	 * @param features A list of {@link javax.xml.ws.WebServiceFeature} to
	 * configure on the proxy. Supported features not in the <code>features</code>
	 * parameter will have their default values.
	 */
	@WebEndpoint(name = FRONT_END_PORT_NAME)
	public FrontEnd getFrontEndPort(WebServiceFeature... features) {
		return getPort(FRONT_END_PORT_QNAME, FrontEnd.class, features);
	}

}
