/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.Messages;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlReplacementTransformer {
    private static final Log log = LogFactory.getLog(UrlReplacementTransformer.class);
    private static final Messages httpMsgs = (Messages)Messages.getMessages(Messages.class);

    public String transform(String baseUri, Map<String, Element> values) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(baseUri);
        for (Map.Entry<String, Element> e : values.entrySet()) {
            String partPattern;
            String replacementValue;
            String partName;
            block4: {
                Element childElement;
                partName = e.getKey();
                Element value = e.getValue();
                replacementValue = DOMUtils.isEmptyElement((Element)value) ? "" : ((childElement = DOMUtils.getFirstChildElement((Element)value)) != null ? DOMUtils.getTextContent((Node)childElement) : DOMUtils.getTextContent((Node)value));
                if (replacementValue == null) continue;
                try {
                    replacementValue = URIUtil.encodeWithinQuery((String)replacementValue);
                }
                catch (URIException urie) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)urie.getMessage(), (Throwable)urie);
                }
            }
            if (this.replace(result, partPattern = "\\(" + partName + "\\)", replacementValue)) continue;
            partPattern = "\\{" + partName + "\\}";
            this.replace(result, partPattern, replacementValue);
        }
        StringBuilder sb = new StringBuilder(128);
        for (String aResult : result) {
            sb.append(aResult);
        }
        return sb.toString();
    }

    private boolean replace(List<String> result, String partPattern, String replacementValue) {
        for (int i = 0; i < result.size(); i += 2) {
            String segment = result.get(i);
            String[] matches = segment.split(partPattern, -1);
            if (matches.length != 2) continue;
            result.remove(i);
            result.add(i, matches[0]);
            result.add(i + 1, replacementValue);
            result.add(i + 2, matches[1]);
            return true;
        }
        return false;
    }
}

