/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.pmapi;

import java.util.HashSet;
import java.util.StringTokenizer;

public class ProcessInfoCustomizer {
    public static final ProcessInfoCustomizer ALL = new ProcessInfoCustomizer(Item.ENDPOINTS, Item.PROPERTIES, Item.DOCUMENTS, Item.SUMMARY);
    public static final ProcessInfoCustomizer SUMMARYONLY = new ProcessInfoCustomizer(Item.SUMMARY);
    public static final ProcessInfoCustomizer NONE = new ProcessInfoCustomizer(new Item[0]);
    private HashSet<Item> _includes = new HashSet();

    public ProcessInfoCustomizer(String value) {
        StringTokenizer stok = new StringTokenizer(value, ",", false);
        while (stok.hasMoreTokens()) {
            String t = stok.nextToken();
            Item i = Item.valueOf(t);
            this._includes.add(i);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean first = false;
        for (Item i : this._includes) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(i.toString());
        }
        return buf.toString();
    }

    public ProcessInfoCustomizer(Item ... items) {
        for (Item i : items) {
            this._includes.add(i);
        }
    }

    public boolean includeInstanceSummary() {
        return this._includes.contains((Object)Item.SUMMARY);
    }

    public boolean includeDocumentLists() {
        return this._includes.contains((Object)Item.DOCUMENTS);
    }

    public boolean includeProcessProperties() {
        return this._includes.contains((Object)Item.PROPERTIES);
    }

    public boolean includeEndpoints() {
        return this._includes.contains((Object)Item.ENDPOINTS);
    }

    public static enum Item {
        SUMMARY,
        DOCUMENTS,
        PROPERTIES,
        ENDPOINTS;

    }
}

