/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.DeferredProcessInstanceCleanable;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.iapi.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessCleanUpRunnable
implements Scheduler.MapSerializableRunnable,
BpelServerImpl.ContextsAware {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(ProcessCleanUpRunnable.class);
    public static final int PROCESS_CLEANUP_TRANSACTION_SIZE = Integer.getInteger("org.apache.ode.processInstanceDeletion.transactionSize", 10);
    private transient Contexts _contexts;
    private transient Serializable _pid;

    public ProcessCleanUpRunnable() {
    }

    public ProcessCleanUpRunnable(Serializable pid) {
        this._pid = pid;
    }

    public void storeToDetailsMap(Map<String, Object> details) {
        details.put("pid", this._pid);
    }

    public void restoreFromDetailsMap(Map<String, Object> details) {
        this._pid = (Serializable)details.get("pid");
    }

    @Override
    public void setContexts(Contexts contexts) {
        this._contexts = contexts;
    }

    public void run() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Deleting runtime data for old process: " + this._pid + "..."));
        }
        try {
            int transactionResultSize = 0;
            do {
                transactionResultSize = (Integer)this._contexts.scheduler.execTransaction((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        ProcessDAO process = ((ProcessCleanUpRunnable)ProcessCleanUpRunnable.this)._contexts.dao.getConnection().createTransientProcess(ProcessCleanUpRunnable.this._pid);
                        if (!(process instanceof DeferredProcessInstanceCleanable)) {
                            throw new IllegalArgumentException("ProcessDAO does not implement DeferredProcessInstanceCleanable!!!");
                        }
                        return ((DeferredProcessInstanceCleanable)process).deleteInstances(PROCESS_CLEANUP_TRANSACTION_SIZE);
                    }
                });
                if (!__log.isDebugEnabled()) continue;
                __log.debug((Object)("Deleted " + transactionResultSize + "instances for old process: " + this._pid + "."));
            } while (transactionResultSize == PROCESS_CLEANUP_TRANSACTION_SIZE);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (__log.isInfoEnabled()) {
            __log.info((Object)("Deleted runtime data for old process: " + this._pid + "."));
        }
    }
}

