/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.util.Set;
import javax.wsdl.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.o.OPartnerLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelatorsMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelatorsMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> registeredProcesses, BpelDAOConnection connection) {
        for (BpelProcess process : registeredProcesses) {
            __log.debug((Object)("Migrating correlators for process " + process.getConf().getProcessId()));
            ProcessDAO processDao = connection.getProcess(process.getConf().getProcessId());
            for (OPartnerLink plink : process.getOProcess().getAllPartnerLinks()) {
                if (!plink.hasMyRole()) continue;
                for (Operation op : plink.myRolePortType.getOperations()) {
                    try {
                        CorrelatorDAO corr = processDao.getCorrelator(plink.getId() + "." + op.getName());
                        corr.setCorrelatorId(plink.getName() + "." + op.getName());
                        __log.debug((Object)("Migrated correlator " + plink.getName() + "." + op.getName()));
                    }
                    catch (IllegalArgumentException e) {
                        __log.debug((Object)("Correlator with id " + plink.getId() + "." + op.getName() + " couldn't be found, skipping."));
                    }
                }
            }
        }
        return true;
    }
}

