/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime.channels;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.utils.SerializableElement;
import org.w3c.dom.Element;

public class FaultData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QName _faultName;
    private OVarType _faultVarType;
    private SerializableElement _faultMsg;
    private OBase _location;
    private final String _explanation;

    public FaultData(QName fault, OBase location, String explanation) {
        this._faultName = fault;
        this._location = location;
        this._explanation = explanation;
    }

    public FaultData(QName fault, Element faultMsg, OVarType faultVarType, OBase location) {
        this(fault, location, null);
        assert (faultMsg != null);
        assert (faultVarType != null);
        assert (faultVarType instanceof OMessageVarType || faultVarType instanceof OElementVarType);
        this._faultMsg = new SerializableElement(faultMsg);
        this._faultVarType = faultVarType;
    }

    public Element getFaultMessage() {
        return this._faultMsg == null ? null : this._faultMsg.getElement();
    }

    public OVarType getFaultType() {
        return this._faultVarType;
    }

    public QName getFaultName() {
        return this._faultName;
    }

    public int getFaultLineNo() {
        return this.findLineNo(this._location);
    }

    public String getExplanation() {
        return this._explanation;
    }

    public int getActivityId() {
        return this._location.getId();
    }

    protected int findLineNo(OBase location) {
        if (location == null) {
            return -1;
        }
        if (location.debugInfo == null) {
            return -1;
        }
        return location.debugInfo.startLine;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FaultData: [faultName=");
        sb.append(this._faultName);
        sb.append(", faulType=");
        sb.append(this._faultVarType);
        if (this._explanation != null) {
            sb.append(" (");
            sb.append(this._explanation);
            sb.append(")");
        }
        sb.append("] @");
        sb.append(this.findLineNo(this._location));
        return sb.toString();
    }
}

