/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessStore;

public class ProcessAndInstanceManagementMBean
implements DynamicMBean {
    private MBeanInfo _mbeanInfo;
    private ProcessAndInstanceManagementImpl _pm;
    private static final List<String> __excludes = new ArrayList<String>();
    private static final Hashtable<String, Class<?>> primitives;

    public ProcessAndInstanceManagementMBean(BpelServer server, ProcessStore store) {
        this(new ProcessAndInstanceManagementImpl(server, store));
    }

    public ProcessAndInstanceManagementMBean(ProcessAndInstanceManagementImpl pm) {
        this._pm = pm;
        ArrayList<MBeanOperationInfo> exposedOperations = new ArrayList<MBeanOperationInfo>();
        for (Method m : pm.getClass().getMethods()) {
            if (__excludes.contains(m.getName())) continue;
            exposedOperations.add(new MBeanOperationInfo(m.getName(), m));
        }
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[exposedOperations.size()];
        operations = exposedOperations.toArray(operations);
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{};
        this._mbeanInfo = new MBeanInfo(this.getClass().getName(), "Process and Instance Management", attributes, constructors, operations, notifications);
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public AttributeList getAttributes(String[] attributes) {
        throw new UnsupportedOperationException();
    }

    public MBeanInfo getMBeanInfo() {
        return this._mbeanInfo;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Method m = this._pm.getClass().getMethod(actionName, this.findTypes(this._pm.getClass().getClassLoader(), signature));
            if (m == null) {
                throw new ReflectionException(new NoSuchMethodException(actionName));
            }
            Object object = m.invoke((Object)this._pm, params);
            return object;
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private Class[] findTypes(ClassLoader loader, String[] signature) throws ReflectionException {
        if (signature == null) {
            return null;
        }
        Class[] result = new Class[signature.length];
        try {
            for (int i = 0; i < signature.length; ++i) {
                result[i] = primitives.get(signature[i]);
                if (result[i] != null) continue;
                result[i] = Class.forName(signature[i], false, loader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        return result;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }

    static {
        __excludes.add("hashCode");
        __excludes.add("equals");
        __excludes.add("getClass");
        __excludes.add("wait");
        __excludes.add("notify");
        __excludes.add("notifyAll");
        __excludes.add("toString");
        primitives = new Hashtable();
        primitives.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitives.put(Character.TYPE.toString(), Character.TYPE);
        primitives.put(Byte.TYPE.toString(), Byte.TYPE);
        primitives.put(Short.TYPE.toString(), Short.TYPE);
        primitives.put(Integer.TYPE.toString(), Integer.TYPE);
        primitives.put(Long.TYPE.toString(), Long.TYPE);
        primitives.put(Float.TYPE.toString(), Float.TYPE);
        primitives.put(Double.TYPE.toString(), Double.TYPE);
    }
}

