/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.MessageExchangeImpl;
import org.apache.ode.bpel.engine.replayer.Replayer;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PartnerRoleMessageExchangeImpl
extends MessageExchangeImpl
implements PartnerRoleMessageExchange {
    private static final Log LOG = LogFactory.getLog(PartnerRoleMessageExchangeImpl.class);
    private PartnerRoleChannel _channel;
    private EndpointReference _myRoleEPR;
    private int responsesReceived;

    protected PartnerRoleMessageExchangeImpl(BpelEngineImpl engine, MessageExchangeDAO dao, PortType portType, Operation operation, EndpointReference epr, EndpointReference myRoleEPR, PartnerRoleChannel channel) {
        super(engine, dao);
        this._myRoleEPR = myRoleEPR;
        this.setPortOp(portType, operation);
        this._channel = channel;
    }

    public void replyOneWayOk() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replyOneWayOk mex=" + this.getMessageExchangeId()));
        }
        this.setStatus(MessageExchange.Status.ASYNC);
    }

    public void replyAsync() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replyAsync mex=" + this.getMessageExchangeId()));
        }
        this.setStatus(MessageExchange.Status.ASYNC);
    }

    public void replyWithFault(QName faultType, Message outputFaultMessage) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replyWithFault mex=" + this.getMessageExchangeId()));
        }
        boolean isAsync = this.isAsync();
        this.setFault(faultType, outputFaultMessage);
        if (isAsync) {
            this.continueAsync();
        }
    }

    public void reply(Message response) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reply mex=" + this.getMessageExchangeId()));
        }
        boolean isAsync = this.isAsync();
        this.setResponse(response);
        if (isAsync) {
            this.continueAsync();
        }
    }

    void setResponse(Message outputMessage) throws BpelEngineException {
        if (++this.responsesReceived > 1 && this.getSubscriberCount() > 1 && this.getStatus() == MessageExchange.Status.RESPONSE) {
            return;
        }
        super.setResponse(outputMessage);
    }

    public void replyWithFailure(MessageExchange.FailureType type, String description, Element details) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            String msg = "replyWithFailure mex=" + this.getMessageExchangeId() + " failureType=" + type + " description=" + description + " details=" + (details == null ? null : DOMUtils.domToString((Node)details));
            LOG.debug((Object)msg);
        }
        boolean isAsync = this.isAsync();
        this.setFailure(type, description, details);
        if (isAsync) {
            this.continueAsync();
        }
    }

    private void continueAsync() {
        if (this.getDAO().getChannel() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("no channel on mex=" + this.getMessageExchangeId()));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("create work event for mex=" + this.getMessageExchangeId()));
        }
        Scheduler.JobDetails we = new Scheduler.JobDetails();
        we.setInstanceId(this.getDAO().getInstance().getInstanceId());
        we.setType(Scheduler.JobType.INVOKE_RESPONSE);
        we.setInMem(Boolean.valueOf(this._engine._activeProcesses.get(this.getDAO().getProcess().getProcessId()).isInMemory()));
        we.setChannel(this.getDAO().getChannel());
        we.setMexId(this.getDAO().getMessageExchangeId());
        Replayer replayer = Replayer.replayer.get();
        if (replayer == null) {
            if (we.getInMem().booleanValue()) {
                this._engine._contexts.scheduler.scheduleVolatileJob(true, we);
            } else {
                this._engine._contexts.scheduler.schedulePersistedJob(we, null);
            }
        } else {
            replayer.scheduler.schedulePersistedJob(we, null);
        }
    }

    private boolean isAsync() {
        return this.getStatus() == MessageExchange.Status.ASYNC;
    }

    public QName getCaller() {
        return this._dao.getProcess().getProcessId();
    }

    public String toString() {
        try {
            return "{PartnerRoleMex#" + this.getMessageExchangeId() + " [PID " + this.getCaller() + "] calling " + this._epr + "." + this.getOperationName() + "(...) Status " + this.getStatus() + "}";
        }
        catch (Throwable t) {
            return "{PartnerRoleMex#????}";
        }
    }

    public PartnerRoleChannel getChannel() {
        return this._channel;
    }

    public EndpointReference getMyRoleEndpointReference() {
        return this._myRoleEPR;
    }
}

