/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.wstx;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.UserBusinessActivity;
import com.arjuna.mw.wst11.common.CoordinationContextHelper;
import com.arjuna.mwlabs.wst11.ba.context.TxContextImple;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.wstx.WebServiceTransaction;
import org.apache.ode.bpel.wstx.WebServiceTransactionType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BusinessActivity
implements WebServiceTransaction {
    private static final Log __log = LogFactory.getLog(BusinessActivity.class);
    protected UserBusinessActivity _uba;
    protected TxContext _txcontext;
    protected boolean _active;
    protected WebServiceTransactionType _type;
    protected boolean _subordinate;

    public BusinessActivity(WebServiceTransactionType type) {
        this._type = type;
        this._active = false;
        this._subordinate = false;
    }

    private static synchronized void begin(UserBusinessActivity uba) throws WrongStateException, SystemException {
        uba.begin();
    }

    public void begin(Message bpelRequest) throws WrongStateException, SystemException {
        MessageImpl req = (MessageImpl)bpelRequest;
        this._subordinate = false;
        if (req._dao.getHeader() != null) {
            try {
                CoordinationContextType cct;
                NodeList cc = req._dao.getHeader().getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
                if (cc.getLength() > 0 && (cct = CoordinationContextHelper.deserialise((Element)((Element)cc.item(0).getFirstChild()))) != null) {
                    TxContextImple ctx = new TxContextImple(cct);
                    BusinessActivityManager.getBusinessActivityManager().resume((TxContext)ctx);
                    this._subordinate = true;
                }
            }
            catch (Exception e) {
                __log.warn((Object)"Wrong coordination context. The transaction won't be subordinated.");
            }
        }
        this._uba = UserBusinessActivity.getUserBusinessActivity();
        if (this._subordinate && this._uba != null) {
            this._uba = UserBusinessActivity.getUserBusinessActivity().getUserSubordinateBusinessActivity();
        }
        if (this._uba == null) {
            throw new SystemException("Distributed transaction has not been created. Check that JBoss XTS is runnning.");
        }
        try {
            BusinessActivity.begin(this._uba);
        }
        catch (WrongStateException wse) {
            BusinessActivityManager.getBusinessActivityManager().suspend();
            this._uba = UserBusinessActivity.getUserBusinessActivity();
            BusinessActivity.begin(this._uba);
        }
        this._txcontext = BusinessActivityManager.getBusinessActivityManager().currentTransaction();
        this._active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SecurityException, UnknownTransactionException, SystemException, WrongStateException {
        this._active = false;
        try {
            this.resume();
            this._uba.close();
        }
        catch (TransactionRolledBackException e) {
            __log.info((Object)"Web service transaction was aborted");
        }
        finally {
            this._uba = null;
            this._txcontext = null;
        }
    }

    public void complete() throws UnknownTransactionException, SystemException, WrongStateException {
        try {
            this.resume();
            this._uba.complete();
        }
        catch (WrongStateException ex) {
            __log.warn((Object)"Business Activity Transaction WrongStateException for completion.");
        }
    }

    public boolean isActive() {
        return this._uba != null && this._active;
    }

    public boolean isSubordinate() {
        return this._subordinate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SecurityException, UnknownTransactionException, SystemException, WrongStateException {
        this._active = false;
        try {
            this.resume();
            this._uba.cancel();
        }
        finally {
            this._uba = null;
            this._txcontext = null;
        }
    }

    public String getTransactionIdentifier() {
        return this._uba.transactionIdentifier();
    }

    public WebServiceTransactionType getType() {
        return this._type;
    }

    public void resume() throws UnknownTransactionException, SystemException {
        if (!this._txcontext.equals((Object)BusinessActivityManager.getBusinessActivityManager().currentTransaction())) {
            BusinessActivityManager.getBusinessActivityManager().resume(this._txcontext);
            this._uba = UserBusinessActivity.getUserBusinessActivity();
        }
    }

    public void suspend() throws SystemException {
        this._txcontext = BusinessActivityManager.getBusinessActivityManager().suspend();
    }

    public Element putCoordinationContext(Element headerElement) throws UnknownTransactionException, SystemException {
        this.resume();
        TxContextImple txContext = (TxContextImple)BusinessActivityManager.getBusinessActivityManager().currentTransaction();
        CoordinationContextType ctx = txContext.context().getCoordinationContext();
        try {
            Document doc = headerElement.getOwnerDocument();
            Element coord = doc.createElementNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
            headerElement.appendChild(coord);
            CoordinationContextHelper.serialise((CoordinationContextType)ctx, (Element)headerElement);
            Element parent = doc.createElementNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
            Node tmp = headerElement.getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext").item(0);
            parent.appendChild(tmp.cloneNode(true));
            headerElement.replaceChild(parent, tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("Coordination context has not been added to the header.");
        }
        return headerElement;
    }
}

