/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xquery10.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDataSource;
import net.sf.saxon.xqj.SaxonXQItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.runtime.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.runtime.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xquery10.o.OXQuery10ExpressionBPEL20;
import org.apache.ode.bpel.explang.ConfigurationException;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.explang.ExpressionLanguageRuntime;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.xsd.Duration;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XQuery10ExpressionRuntime
implements ExpressionLanguageRuntime {
    static final short NODE_TYPE = 1;
    static final short NODESET_TYPE = 2;
    static final short STRING_TYPE = 3;
    static final short BOOLEAN_TYPE = 4;
    static final short NUMBER_TYPE = 5;
    private static final Log __log = LogFactory.getLog(XQuery10ExpressionRuntime.class);

    public void initialize(Map properties) throws ConfigurationException {
        TransformerFactoryImpl trsf = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)trsf);
    }

    public String evaluateAsString(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        return (String)this.evaluate(cexp, ctx, XPathConstants.STRING);
    }

    public boolean evaluateAsBoolean(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        return (Boolean)this.evaluate(cexp, ctx, XPathConstants.BOOLEAN);
    }

    public Number evaluateAsNumber(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        return (Number)this.evaluate(cexp, ctx, XPathConstants.NUMBER);
    }

    public List evaluate(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        List<Node> result;
        Object someRes = this.evaluate(cexp, ctx, XPathConstants.NODESET);
        if (someRes instanceof List) {
            result = (ArrayList<Node>)someRes;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Returned list of size " + result.size()));
            }
            if (result.size() == 1 && !(result.get(0) instanceof Node)) {
                Object simpleType = result.get(0);
                String textVal = simpleType instanceof Date ? ISO8601DateParser.format((Date)((Date)simpleType)) : (simpleType instanceof DurationValue ? ((DurationValue)simpleType).getStringValue() : simpleType.toString());
                Document d = DOMUtils.newDocument();
                Element wrapper = d.createElement("wrapper");
                Text text = d.createTextNode(textVal);
                wrapper.appendChild(text);
                d.appendChild(wrapper);
                result = Collections.singletonList(text);
            }
        } else if (someRes instanceof NodeList) {
            NodeList retVal = (NodeList)someRes;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Returned node list of size " + retVal.getLength()));
            }
            result = new ArrayList<Node>(retVal.getLength());
            for (int m = 0; m < retVal.getLength(); ++m) {
                Node val = retVal.item(m);
                if (val.getNodeType() == 9) {
                    val = ((Document)val).getDocumentElement();
                }
                result.add(val);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Node evaluateNode(OExpression cexp, EvaluationContext ctx) throws FaultException, EvaluationException {
        List retVal = this.evaluate(cexp, ctx);
        if (retVal.size() == 0) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "No results for expression: " + cexp);
        }
        if (retVal.size() > 1) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + cexp);
        }
        return (Node)retVal.get(0);
    }

    public Calendar evaluateAsDate(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        List literal = DOMUtils.toList((Object)this.evaluate(cexp, context, XPathConstants.NODESET));
        if (literal.size() == 0) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "No results for expression: " + cexp);
        }
        if (literal.size() > 1) {
            throw new FaultException(cexp.getOwner().constants.qnSelectionFailure, "Multiple results for expression: " + cexp);
        }
        Object date = literal.get(0);
        if (date instanceof Calendar) {
            return (Calendar)date;
        }
        if (date instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)date);
            return cal;
        }
        if (date instanceof Element) {
            date = ((Element)date).getTextContent();
        }
        try {
            return ISO8601DateParser.parseCal((String)date.toString());
        }
        catch (Exception ex) {
            String errmsg = "Invalid date: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    public Duration evaluateAsDuration(OExpression cexp, EvaluationContext context) throws FaultException, EvaluationException {
        String literal = this.evaluateAsString(cexp, context);
        try {
            return new Duration(literal);
        }
        catch (Exception ex) {
            String errmsg = "Invalid duration: " + literal;
            __log.error((Object)errmsg, (Throwable)ex);
            throw new FaultException(cexp.getOwner().constants.qnInvalidExpressionValue, errmsg);
        }
    }

    private Object evaluate(OExpression cexp, EvaluationContext ctx, QName type) throws FaultException, EvaluationException {
        try {
            OXQuery10ExpressionBPEL20 oxquery10 = (OXQuery10ExpressionBPEL20)cexp;
            SaxonXQDataSource xqds = new SaxonXQDataSource();
            XQConnection xqconn = xqds.getConnection();
            Configuration configuration = ((SaxonXQConnection)xqconn).getConfiguration();
            configuration.setAllNodesUntyped(true);
            configuration.setHostLanguage(51);
            XQStaticContext staticEnv = xqconn.getStaticContext();
            NSContext nsContext = oxquery10.namespaceCtx;
            Set prefixes = nsContext.getPrefixes();
            for (String prefix : prefixes) {
                String uri = nsContext.getNamespaceURI(prefix);
                staticEnv.declareNamespace(prefix, uri);
            }
            configuration.setSchemaValidationMode(4);
            xqconn.setStaticContext(staticEnv);
            String xquery = oxquery10.xquery.replaceFirst("org.apache.ode.bpel.elang.xquery10.compiler.XQuery10BpelFunctions", "org.apache.ode.bpel.elang.xquery10.runtime.XQuery10BpelFunctions");
            XQPreparedExpression exp = xqconn.prepareExpression(xquery);
            JaxpFunctionResolver funcResolver = new JaxpFunctionResolver(ctx, (OXPath20ExpressionBPEL20)oxquery10);
            JaxpVariableResolver variableResolver = new JaxpVariableResolver(ctx, (OXPath10ExpressionBPEL20)oxquery10, configuration);
            for (QName variable : exp.getAllUnboundExternalVariables()) {
                Object value = variableResolver.resolveVariable(variable);
                if (value instanceof Value) {
                    SaxonXQConnection saxonConn = (SaxonXQConnection)xqconn;
                    try {
                        Item item = ((Value)value).asItem();
                        if (item == null) {
                            exp.bindSequence(variable, xqconn.createSequence(Collections.EMPTY_LIST.iterator()));
                            continue;
                        }
                        SaxonXQItem item2 = new SaxonXQItem(item, (SaxonXQDataFactory)saxonConn);
                        exp.bindItem(variable, (XQItem)item2);
                    }
                    catch (XPathException e) {
                        __log.warn((Object)"", (Throwable)e);
                    }
                    continue;
                }
                if (value instanceof Date) {
                    Date d = (Date)value;
                    value = ISO8601DateParser.format((Date)d);
                }
                XQSequenceType xqType = this.getItemType(xqconn, value);
                if (!(value instanceof Node) && value instanceof NodeList) {
                    NodeList nodeList = (NodeList)value;
                    ArrayList<Node> nodeArray = new ArrayList<Node>();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        nodeArray.add(nodeList.item(i));
                    }
                    value = xqconn.createSequence(nodeArray.iterator());
                }
                if (value == null || xqType == null) continue;
                if (value instanceof XQSequence) {
                    exp.bindSequence(variable, (XQSequence)value);
                    continue;
                }
                if (!(xqType instanceof XQItemType)) continue;
                exp.bindObject(variable, value, (XQItemType)xqType);
            }
            Node contextNode = ctx.getRootNode() == null ? DOMUtils.newDocument() : ctx.getRootNode();
            contextNode.setUserData("function-resolver", funcResolver, null);
            exp.bindItem(XQConstants.CONTEXT_ITEM, xqconn.createItemFromNode(contextNode, xqconn.createNodeType()));
            XQResultSequence result = exp.executeQuery();
            Object evalResult = this.getResultValue(type, result);
            if (evalResult != null && __log.isDebugEnabled()) {
                __log.debug((Object)("Expression " + cexp.toString() + " generated result " + evalResult + " - type=" + evalResult.getClass().getName()));
                if (ctx.getRootNode() != null) {
                    __log.debug((Object)("Was using context node " + DOMUtils.domToString((Node)ctx.getRootNode())));
                }
            }
            return evalResult;
        }
        catch (XQException xqe) {
            Throwable th;
            Throwable cause;
            Throwable throwable = cause = xqe.getCause() != null ? xqe.getCause() : xqe;
            if (cause instanceof DynamicError && (th = ((DynamicError)cause).getException()) != null && (cause = th).getCause() != null) {
                cause = cause.getCause();
            }
            throw new EvaluationException("Error while executing an XQuery expression: " + cause.toString(), cause);
        }
        catch (WrappedResolverException wre) {
            __log.debug((Object)"Could not evaluate expression because of ", (Throwable)wre);
            throw (FaultException)wre.getCause();
        }
    }

    private Object getItemValue(XQItem item) throws XQException {
        XQItemType itemType = item.getItemType();
        Object itemValue = null;
        switch (itemType.getBaseType()) {
            case 10: {
                itemValue = item.getBoolean();
                break;
            }
            case 17: {
                itemValue = item.getDouble();
                break;
            }
            case 31: {
                itemValue = item.getByte();
                break;
            }
            case 20: {
                itemValue = Float.valueOf(item.getFloat());
                break;
            }
            case 12: 
            case 13: {
                itemValue = item.getInt();
                break;
            }
            case 15: {
                itemValue = item.getLong();
                break;
            }
            case 2: {
                itemValue = item.getNode();
                break;
            }
            case 8: {
                itemValue = item.getNodeUri();
                break;
            }
            case 14: {
                itemValue = item.getShort();
                break;
            }
            case 4: 
            case 29: {
                itemValue = item.getAtomicValue();
            }
        }
        return itemValue;
    }

    private XQSequenceType getItemType(XQConnection xqconn, Object value) throws XQException {
        XQItemType xqType = null;
        if (value instanceof Long) {
            xqType = xqconn.createAtomicType(15);
        } else if (value instanceof String) {
            xqType = xqconn.createAtomicType(29);
        } else if (value instanceof Boolean) {
            xqType = xqconn.createAtomicType(10);
        } else if (value instanceof Date) {
            xqType = xqconn.createAtomicType(16);
        } else if (value instanceof BigDecimal) {
            xqType = xqconn.createAtomicType(17);
        } else if (value instanceof Float) {
            xqType = xqconn.createAtomicType(20);
        } else if (value instanceof URI) {
            xqType = xqconn.createAtomicType(8);
        } else if (value instanceof QName) {
            xqType = xqconn.createAtomicType(28);
        } else if (value instanceof BigInteger) {
            xqType = xqconn.createAtomicType(12);
        } else if (value instanceof Integer) {
            xqType = xqconn.createAtomicType(13);
        } else if (value instanceof Double) {
            xqType = xqconn.createAtomicType(18);
        } else if (value instanceof Byte) {
            xqType = xqconn.createAtomicType(31);
        } else if (value instanceof Node) {
            xqType = xqconn.createNodeType();
        } else if (value instanceof NodeList || value instanceof XQSequence) {
            XQItemType xqItemType = xqconn.createNodeType();
            xqType = xqconn.createSequenceType(xqItemType, 3);
        }
        return xqType;
    }

    private Object getResultValue(QName type, XQResultSequence result) throws XQException {
        Document document = DOMUtils.newDocument();
        Object resultValue = null;
        if (XPathConstants.NODESET.equals(type)) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (result.next()) {
                Object itemValue = this.getItemValue(result.getItem());
                if (itemValue instanceof Document) {
                    itemValue = DOMUtils.cloneNode((Document)document, (Node)((Document)itemValue).getDocumentElement());
                } else if (itemValue instanceof Node) {
                    itemValue = DOMUtils.cloneNode((Document)document, (Node)((Node)itemValue));
                }
                if (itemValue == null) continue;
                list.add(itemValue);
            }
            resultValue = list;
        } else if (XPathConstants.NODE.equals(type)) {
            XQItem item = null;
            if (result.count() > 0) {
                result.first();
                if (result.isOnItem()) {
                    item = result.getItem();
                }
            }
            if (item != null && (resultValue = this.getItemValue(item)) instanceof Node) {
                resultValue = DOMUtils.cloneNode((Document)document, (Node)((Node)resultValue));
            }
        } else if (XPathConstants.STRING.equals(type)) {
            resultValue = result.getSequenceAsString(new Properties());
        } else if (XPathConstants.NUMBER.equals(type)) {
            resultValue = result.getSequenceAsString(new Properties());
            resultValue = Integer.parseInt((String)resultValue);
        } else if (XPathConstants.BOOLEAN.equals(type)) {
            resultValue = result.getSequenceAsString(new Properties());
            resultValue = Boolean.parseBoolean((String)resultValue);
        }
        return resultValue;
    }
}

