/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.OutstandingRequestManager;
import org.apache.ode.bpel.engine.ReplacementMapImpl;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.bpel.engine.migration.OldCorrelationKey;
import org.apache.ode.bpel.engine.migration.OldSelector;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationKeySetMigration
implements Migration {
    private static final Log __log = LogFactory.getLog(CorrelationKeySetMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> registeredProcesses, BpelDAOConnection connection) {
        boolean v1First = true;
        for (BpelProcess process : registeredProcesses) {
            ProcessDAO processDao = connection.getProcess(process.getConf().getProcessId());
            Collection pis = processDao.getActiveInstances();
            for (ProcessInstanceDAO instance : pis) {
                __log.debug((Object)("Migrating correlation key in jacob for instance " + instance.getInstanceId()));
                OProcess oproc = this.findOProcess(registeredProcesses, instance.getProcess().getProcessId());
                if (v1First) {
                    if (this.updateV1Key(instance, oproc)) continue;
                    v1First = false;
                    this.updateV2Key(instance, oproc);
                    continue;
                }
                if (this.updateV2Key(instance, oproc)) continue;
                v1First = true;
                this.updateV1Key(instance, oproc);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateV1Key(ProcessInstanceDAO instance, OProcess oproc) {
        ExecutionQueueImpl soup;
        try {
            soup = this.readOldState(instance, oproc, this.getClass().getClassLoader(), true);
            if (soup == null) {
                return false;
            }
        }
        catch (Exception e) {
            __log.debug((Object)("  failed to read a v1 state for instance " + instance.getInstanceId()));
            ExecutionQueueImpl._classDescriptors.clear();
            return false;
        }
        try {
            OutstandingRequestManager orm = (OutstandingRequestManager)soup.getGlobalData();
            for (OutstandingRequestManager.Entry entry : orm._byChannel.values()) {
                Selector[] newSelectors = new Selector[entry.selectors.length];
                int index = 0;
                for (Object selector : entry.selectors) {
                    OldSelector sel = (OldSelector)selector;
                    Object selCKey = sel.correlationKey;
                    if (selCKey == null) continue;
                    OldCorrelationKey old = (OldCorrelationKey)selCKey;
                    __log.debug((Object)("   Changing V1 key " + old.toCanonicalString()));
                    CorrelationKeySet newKeySet = new CorrelationKeySet();
                    newKeySet.add(new CorrelationKey("" + old.getCSetId(), old.getValues()));
                    Selector newSelector = new Selector(sel.idx, sel.plinkInstance, sel.opName, sel.oneWay, sel.messageExchangeId, newKeySet, "one");
                    newSelector.correlationKey = new CorrelationKey("" + old.getCSetId(), old.getValues());
                    newSelectors[index++] = newSelector;
                }
                entry.selectors = newSelectors;
            }
            this.writeOldState(instance, soup);
        }
        finally {
            ExecutionQueueImpl._classDescriptors.clear();
        }
        return true;
    }

    private boolean updateV2Key(ProcessInstanceDAO instance, OProcess oproc) {
        ExecutionQueueImpl soup;
        try {
            soup = this.readOldState(instance, oproc, this.getClass().getClassLoader(), false);
            if (soup == null) {
                return false;
            }
        }
        catch (Exception e) {
            __log.debug((Object)("  failed to read a v2 state for instance " + instance.getInstanceId()));
            ExecutionQueueImpl._classDescriptors.clear();
            return false;
        }
        OutstandingRequestManager orm = (OutstandingRequestManager)soup.getGlobalData();
        for (OutstandingRequestManager.Entry entry : orm._byChannel.values()) {
            Selector[] newSelectors = new Selector[entry.selectors.length];
            int index = 0;
            for (Object selector : entry.selectors) {
                OldSelector sel = (OldSelector)selector;
                CorrelationKey selCKey = (CorrelationKey)sel.correlationKey;
                if (selCKey == null) continue;
                __log.debug((Object)("   Changing V2 key " + selCKey.toCanonicalString()));
                CorrelationKeySet newKeySet = new CorrelationKeySet();
                newKeySet.add(new CorrelationKey("" + selCKey.getCorrelationSetName(), selCKey.getValues()));
                Selector newSelector = new Selector(sel.idx, sel.plinkInstance, sel.opName, sel.oneWay, sel.messageExchangeId, newKeySet, "one");
                newSelector.correlationKey = new CorrelationKey("" + selCKey.getCorrelationSetName(), selCKey.getValues());
                newSelectors[index++] = newSelector;
            }
            entry.selectors = newSelectors;
        }
        this.writeOldState(instance, soup);
        return true;
    }

    private ExecutionQueueImpl readOldState(ProcessInstanceDAO instance, OProcess oprocess, ClassLoader cl, boolean changeKey) {
        if (instance.getExecutionState() == null) {
            return null;
        }
        try {
            ObjectStreamClass osc;
            ExecutionQueueImpl soup = new ExecutionQueueImpl(cl);
            if (changeKey) {
                osc = ObjectStreamClass.lookup(Class.forName("org.apache.ode.bpel.engine.migration.OldCorrelationKey", true, cl));
                ExecutionQueueImpl._classDescriptors.put("org.apache.ode.bpel.common.CorrelationKey", osc);
            }
            osc = ObjectStreamClass.lookup(Class.forName("org.apache.ode.bpel.engine.migration.OldSelector", true, cl));
            ExecutionQueueImpl._classDescriptors.put("org.apache.ode.bpel.runtime.Selector", osc);
            osc = ObjectStreamClass.lookup(Class.forName("[Lorg.apache.ode.bpel.engine.migration.OldSelector;", true, this.getClass().getClassLoader()));
            ExecutionQueueImpl._classDescriptors.put("[Lorg.apache.ode.bpel.runtime.Selector;", osc);
            soup.setReplacementMap((ReplacementMap)new ReplacementMapImpl(oprocess));
            ByteArrayInputStream iis = new ByteArrayInputStream(instance.getExecutionState());
            soup.read((InputStream)iis);
            return soup;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeOldState(ProcessInstanceDAO instance, ExecutionQueueImpl soup) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            soup.write((OutputStream)bos);
            bos.close();
            instance.setExecutionState(bos.toByteArray());
            ExecutionQueueImpl._classDescriptors.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OProcess findOProcess(Set<BpelProcess> registeredProcesses, QName name) {
        for (BpelProcess process : registeredProcesses) {
            if (!process.getConf().getProcessId().equals(name)) continue;
            return process.getOProcess();
        }
        return null;
    }
}

