/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.extvar;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.extvar.ExternalVariableConf;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.o.OBase;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExternalVariableManager {
    private static final Log __log = LogFactory.getLog(ExternalVariableManager.class);
    private Map<QName, ExternalVariableModule> _engines;
    private final Map<String, EVar> _externalVariables = new HashMap<String, EVar>();
    private final ExternalVariableConf _extVarConf;
    private QName _pid;

    public ExternalVariableManager(QName pid, ExternalVariableConf evconf, Map<QName, ExternalVariableModule> engines, OProcess oprocess) throws BpelEngineException {
        this._pid = pid;
        this._extVarConf = evconf;
        this._engines = engines;
        boolean fatal = false;
        for (ExternalVariableConf.Variable var : this._extVarConf.getVariables()) {
            EVar evar = new EVar(var.extVariableId, this._engines.get(var.engineQName), var.configuration);
            if (evar._engine == null) {
                __log.error((Object)("External variable engine \"" + var.engineQName + "\" referenced by external variable \"" + var.extVariableId + "\" not registered."));
                fatal = true;
                continue;
            }
            try {
                evar._engine.configure(this._pid, evar._extVarId, evar._config);
            }
            catch (ExternalVariableModuleException eve) {
                __log.error((Object)"External variable subsystem configuration error.", (Throwable)eve);
                throw new BpelEngineException("External variable subsystem configuration error.", (Throwable)eve);
            }
            if (this._externalVariables.containsKey(var.extVariableId)) {
                __log.warn((Object)("Duplicate external variable configuration for \"" + var.extVariableId + "\" will be ignored!"));
            }
            this._externalVariables.put(var.extVariableId, evar);
        }
        for (OBase child : oprocess.getChildren()) {
            if (!(child instanceof OScope)) continue;
            OScope oscope = (OScope)child;
            for (OScope.Variable var : oscope.variables.values()) {
                EVar evar;
                if (var.extVar == null || (evar = this._externalVariables.get(var.extVar.externalVariableId)) != null) continue;
                __log.error((Object)("The \"" + oscope.name + "\" scope declared an unknown external variable \"" + var.extVar.externalVariableId + "\"; check the deployment descriptor."));
                fatal = true;
            }
        }
        if (fatal) {
            String errmsg = "Error initializing external variables. See log for details.";
            __log.error((Object)errmsg);
            throw new BpelEngineException(errmsg);
        }
    }

    public ExternalVariableModule.Value read(OScope.Variable variable, Node reference, Long iid) throws ExternalVariableModuleException {
        EVar evar = this._externalVariables.get(variable.extVar.externalVariableId);
        if (evar == null) {
            throw new BpelEngineException("InternalError: reference to unknown external variable " + variable.extVar.externalVariableId);
        }
        ExternalVariableModule.Locator locator = new ExternalVariableModule.Locator(variable.extVar.externalVariableId, this._pid, iid, reference);
        ExternalVariableModule.Value newval = evar._engine.readValue(((OElementVarType)variable.type).elementType, locator);
        if (newval == null) {
            return null;
        }
        return newval;
    }

    public ExternalVariableModule.Value write(OScope.Variable variable, Node reference, Node val, Long iid) throws ExternalVariableModuleException {
        EVar evar = this._externalVariables.get(variable.extVar.externalVariableId);
        if (evar == null) {
            throw new BpelEngineException("InternalError: reference to unknown external variable " + variable.extVar.externalVariableId);
        }
        ExternalVariableModule.Locator locator = new ExternalVariableModule.Locator(variable.extVar.externalVariableId, this._pid, iid, reference);
        ExternalVariableModule.Value newval = new ExternalVariableModule.Value(locator, val, null);
        newval = evar._engine.writeValue(((OElementVarType)variable.type).elementType, newval);
        return newval;
    }

    static final class EVar {
        final ExternalVariableModule _engine;
        final Element _config;
        final String _extVarId;

        EVar(String id, ExternalVariableModule engine, Element config) {
            this._extVarId = id;
            this._engine = engine;
            this._config = config;
        }
    }
}

