/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.hibernate;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.jpa.JpaConnection;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.bpel.ActivityRecoveryDAOImpl;
import org.apache.ode.dao.jpa.bpel.BpelDAOConnectionImpl;
import org.apache.ode.dao.jpa.bpel.CorrSetProperty;
import org.apache.ode.dao.jpa.bpel.CorrelationSetDAOImpl;
import org.apache.ode.dao.jpa.bpel.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.bpel.EventDAOImpl;
import org.apache.ode.dao.jpa.bpel.FaultDAOImpl;
import org.apache.ode.dao.jpa.bpel.MessageDAOImpl;
import org.apache.ode.dao.jpa.bpel.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.bpel.MessageRouteDAOImpl;
import org.apache.ode.dao.jpa.bpel.MexProperty;
import org.apache.ode.dao.jpa.bpel.PartnerLinkDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;
import org.apache.ode.dao.jpa.bpel.ScopeDAOImpl;
import org.apache.ode.dao.jpa.bpel.XmlDataDAOImpl;
import org.apache.ode.dao.jpa.bpel.XmlDataProperty;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.dao.jpa.hibernate.JpaOperatorImpl;
import org.hibernate.ejb.Ejb3Configuration;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.Tuple;

public class BpelDAOConnectionFactoryImpl
implements BpelDAOConnectionFactory {
    static final Log __log = LogFactory.getLog(BpelDAOConnectionFactoryImpl.class);
    JpaOperator _operator = new JpaOperatorImpl();
    EntityManagerFactory _emf;
    TransactionManager _txm;
    DataSource _ds;

    public void init(Properties odeConfig, TransactionManager txm, Object env) {
        this._txm = txm;
        this._ds = (DataSource)env;
        Map emfProperties = HibernateUtil.buildConfig("dao.factory.", odeConfig, this._txm, this._ds);
        Ejb3Configuration cfg = new Ejb3Configuration();
        this._emf = cfg.addAnnotatedClass(ActivityRecoveryDAOImpl.class).addAnnotatedClass(CorrelationSetDAOImpl.class).addAnnotatedClass(CorrelatorDAOImpl.class).addAnnotatedClass(EventDAOImpl.class).addAnnotatedClass(FaultDAOImpl.class).addAnnotatedClass(MessageDAOImpl.class).addAnnotatedClass(MessageExchangeDAOImpl.class).addAnnotatedClass(MessageRouteDAOImpl.class).addAnnotatedClass(PartnerLinkDAOImpl.class).addAnnotatedClass(ProcessDAOImpl.class).addAnnotatedClass(ProcessInstanceDAOImpl.class).addAnnotatedClass(ScopeDAOImpl.class).addAnnotatedClass(XmlDataDAOImpl.class).addAnnotatedClass(CorrSetProperty.class).addAnnotatedClass(MexProperty.class).addAnnotatedClass(XmlDataProperty.class).addAnnotatedClass(Event.class).addAnnotatedClass(Tuple.class).configure(emfProperties).buildEntityManagerFactory();
        odeConfig.put("ode.emf", this._emf);
    }

    public BpelDAOConnection getConnection() {
        ThreadLocal currentConnection = BpelDAOConnectionImpl.getThreadLocal();
        BpelDAOConnectionImpl conn = (BpelDAOConnectionImpl)currentConnection.get();
        if (conn != null && HibernateUtil.isOpen((JpaConnection)conn)) {
            return conn;
        }
        EntityManager em = this._emf.createEntityManager();
        conn = new BpelDAOConnectionImpl(em, this._txm, this._operator);
        currentConnection.set(conn);
        return conn;
    }

    public void shutdown() {
        this._emf.close();
    }
}

