/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.hibernate;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.JpaConnection;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.dao.jpa.hibernate.JpaOperatorImpl;
import org.apache.ode.dao.jpa.scheduler.JobDAOImpl;
import org.apache.ode.dao.jpa.scheduler.SchedulerDAOConnectionImpl;
import org.apache.ode.dao.scheduler.SchedulerDAOConnection;
import org.apache.ode.dao.scheduler.SchedulerDAOConnectionFactory;
import org.hibernate.ejb.Ejb3Configuration;

public class SchedulerDAOConnectionFactoryImpl
implements SchedulerDAOConnectionFactory {
    static final Log __log = LogFactory.getLog(SchedulerDAOConnectionFactoryImpl.class);
    EntityManagerFactory _emf;
    TransactionManager _txm;
    DataSource _ds;
    JpaOperator _operator = new JpaOperatorImpl();

    public void init(Properties odeConfig, TransactionManager txm, Object env) {
        this._txm = txm;
        this._ds = (DataSource)env;
        Map emfProperties = HibernateUtil.buildConfig("dao.factory.scheduler.", odeConfig, this._txm, this._ds);
        Ejb3Configuration cfg = new Ejb3Configuration();
        this._emf = cfg.addAnnotatedClass(JobDAOImpl.class).configure(emfProperties).createEntityManagerFactory();
    }

    public SchedulerDAOConnection getConnection() {
        ThreadLocal currentConnection = SchedulerDAOConnectionImpl.getThreadLocal();
        SchedulerDAOConnectionImpl conn = (SchedulerDAOConnectionImpl)currentConnection.get();
        if (conn != null && HibernateUtil.isOpen((JpaConnection)conn)) {
            return conn;
        }
        EntityManager em = this._emf.createEntityManager();
        conn = new SchedulerDAOConnectionImpl(em, this._txm, this._operator);
        currentConnection.set(conn);
        return conn;
    }

    public void shutdown() {
        this._emf.close();
    }
}

