/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.helpers.AbsoluteTimeDateFormat;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.DatabaseException;
import org.apache.ode.scheduler.simple.Job;
import org.apache.ode.scheduler.simple.JobNoLongerInDbException;
import org.apache.ode.scheduler.simple.SchedulerThread;
import org.apache.ode.scheduler.simple.Task;
import org.apache.ode.scheduler.simple.TaskRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScheduler
implements Scheduler,
TaskRunner {
    private static final Log __log = LogFactory.getLog(SimpleScheduler.class);
    private static final int DEFAULT_TRANSACTION_TIMEOUT = 60000;
    long _immediateInterval = 30000L;
    long _nearFutureInterval = 600000L;
    long _staleInterval = 10000L;
    long _warningDelay = 300000L;
    int _tps = 100;
    TransactionManager _txm;
    ExecutorService _exec;
    String _nodeId;
    int _todoLimit = 10000;
    volatile Scheduler.JobProcessor _jobProcessor;
    volatile Scheduler.JobProcessor _polledRunnableProcessor;
    private SchedulerThread _todo;
    private DatabaseDelegate _db;
    private CopyOnWriteArraySet<String> _knownNodes = new CopyOnWriteArraySet();
    private ConcurrentHashMap<String, Long> _lastHeartBeat = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> _outstandingJobs = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> _processedSinceLastLoadTask = new ConcurrentHashMap();
    private boolean _running;
    private AtomicLong _nextUpgrade = new AtomicLong();
    private Random _random = new Random();
    private long _pollIntervalForPolledRunnable = Long.getLong("org.apache.ode.polledRunnable.pollInterval", 600000L);
    private int _immediateTransactionRetryLimit = 3;
    private long _immediateTransactionRetryInterval = 1000L;

    public SimpleScheduler(String nodeId, DatabaseDelegate del, Properties conf) {
        this._nodeId = nodeId;
        this._db = del;
        this._todoLimit = this.getIntProperty(conf, "ode.scheduler.queueLength", this._todoLimit);
        this._immediateInterval = this.getLongProperty(conf, "ode.scheduler.immediateInterval", this._immediateInterval);
        this._nearFutureInterval = this.getLongProperty(conf, "ode.scheduler.nearFutureInterval", this._nearFutureInterval);
        this._staleInterval = this.getLongProperty(conf, "ode.scheduler.staleInterval", this._staleInterval);
        this._tps = this.getIntProperty(conf, "ode.scheduler.transactionsPerSecond", this._tps);
        this._warningDelay = this.getLongProperty(conf, "ode.scheduler.warningDelay", this._warningDelay);
        this._immediateTransactionRetryLimit = this.getIntProperty(conf, "ode.scheduler.immediateTransactionRetryLimit", this._immediateTransactionRetryLimit);
        this._immediateTransactionRetryInterval = this.getLongProperty(conf, "ode.scheduler.immediateTransactionRetryInterval", this._immediateTransactionRetryInterval);
        this._todo = new SchedulerThread(this);
    }

    public void setPollIntervalForPolledRunnable(long pollIntervalForPolledRunnable) {
        this._pollIntervalForPolledRunnable = pollIntervalForPolledRunnable;
    }

    private int getIntProperty(Properties props, String propName, int defaultValue) {
        String s = props.getProperty(propName);
        if (s != null) {
            return Integer.parseInt(s);
        }
        return defaultValue;
    }

    private long getLongProperty(Properties props, String propName, long defaultValue) {
        String s = props.getProperty(propName);
        if (s != null) {
            return Long.parseLong(s);
        }
        return defaultValue;
    }

    public void setNodeId(String nodeId) {
        this._nodeId = nodeId;
    }

    public void setStaleInterval(long staleInterval) {
        this._staleInterval = staleInterval;
    }

    public void setImmediateInterval(long immediateInterval) {
        this._immediateInterval = immediateInterval;
    }

    public void setNearFutureInterval(long nearFutureInterval) {
        this._nearFutureInterval = nearFutureInterval;
    }

    public void setTransactionsPerSecond(int tps) {
        this._tps = tps;
    }

    public void setTransactionManager(TransactionManager txm) {
        this._txm = txm;
    }

    public void setDatabaseDelegate(DatabaseDelegate dbd) {
        this._db = dbd;
    }

    public void setExecutorService(ExecutorService executorService) {
        this._exec = executorService;
    }

    public void setPolledRunnableProcesser(Scheduler.JobProcessor polledRunnableProcessor) {
        this._polledRunnableProcessor = polledRunnableProcessor;
    }

    public void cancelJob(String jobId) throws ContextException {
        this._todo.dequeue(new Job(0L, jobId, false, null));
        this._outstandingJobs.remove(jobId);
        try {
            this._db.deleteJob(jobId, this._nodeId);
        }
        catch (DatabaseException e) {
            __log.debug((Object)"Job removal failed.", (Throwable)e);
            throw new ContextException("Job removal failed.", (Throwable)e);
        }
    }

    public <T> Future<T> execIsolatedTransaction(final Callable<T> transaction) throws Exception, ContextException {
        return this._exec.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    return SimpleScheduler.this.execTransaction(transaction);
                }
                catch (Exception e) {
                    __log.error((Object)"An exception occured while executing an isolated transaction, the transaction is going to be abandoned.", (Throwable)e);
                    return null;
                }
            }
        });
    }

    public <T> T execTransaction(Callable<T> transaction) throws Exception, ContextException {
        return this.execTransaction(transaction, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execTransaction(Callable<T> transaction, int timeout) throws Exception, ContextException {
        block36: {
            block35: {
                txm = this._txm;
                if (txm == null) {
                    throw new ContextException("Cannot locate the transaction manager; the server might be shutting down.");
                }
                if (timeout < 0) {
                    throw new IllegalArgumentException("Timeout must be positive, received: " + timeout);
                }
                existingTransaction = false;
                try {
                    existingTransaction = txm.getTransaction() != null;
                }
                catch (Exception ex) {
                    errmsg = "Internal Error, could not get current transaction.";
                    throw new ContextException(errmsg, (Throwable)ex);
                }
                if (existingTransaction) {
                    return transaction.call();
                }
                ex = null;
                immediateRetryCount = this._immediateTransactionRetryLimit;
                this._txm.setTransactionTimeout(timeout);
                if (SimpleScheduler.__log.isDebugEnabled() && timeout != 0) {
                    SimpleScheduler.__log.debug((Object)("Custom transaction timeout: " + timeout));
                }
                try {
                    while (true) {
                        try {
                            if (SimpleScheduler.__log.isDebugEnabled()) {
                                SimpleScheduler.__log.debug((Object)"Beginning a new transaction");
                            }
                            txm.begin();
                        }
                        catch (Exception e) {
                            errmsg = "Internal Error, could not begin transaction.";
                            throw new ContextException(errmsg, (Throwable)e);
                        }
                        try {
                            ex = null;
                            e = transaction.call();
                            var10_12 = null;
                            if (ex != null) ** GOTO lbl74
                            ** GOTO lbl66
                        }
                        catch (Exception e) {
                            block38: {
                                block34: {
                                    block37: {
                                        try {
                                            ex = e;
                                            var10_12 = null;
                                            if (ex == null) {
                                            }
                                            break block34;
                                        }
                                        catch (Throwable var9_18) {
                                            var10_12 = null;
                                            if (ex == null) {
                                                if (SimpleScheduler.__log.isDebugEnabled()) {
                                                    SimpleScheduler.__log.debug((Object)("Commiting on " + txm + "..."));
                                                }
                                                try {
                                                    txm.commit();
                                                }
                                                catch (Exception e2) {
                                                    ex = e2;
                                                }
                                            } else {
                                                if (SimpleScheduler.__log.isDebugEnabled()) {
                                                    SimpleScheduler.__log.debug((Object)("Rollbacking on " + txm + "..."));
                                                }
                                                txm.rollback();
                                            }
                                            if (ex == null) throw var9_18;
                                            if (immediateRetryCount <= 0) throw var9_18;
                                            if (SimpleScheduler.__log.isDebugEnabled()) {
                                                SimpleScheduler.__log.debug((Object)("Will retry the transaction in " + this._immediateTransactionRetryInterval + " msecs on " + this._txm + " for error: "), (Throwable)ex);
                                            }
                                            Thread.sleep(this._immediateTransactionRetryInterval);
                                            throw var9_18;
                                        }
lbl66:
                                        // 1 sources

                                        if (SimpleScheduler.__log.isDebugEnabled()) {
                                            SimpleScheduler.__log.debug((Object)("Commiting on " + txm + "..."));
                                        }
                                        ** try [egrp 5[TRYBLOCK] [6 : 301->310)] { 
lbl69:
                                        // 1 sources

                                        txm.commit();
lbl71:
                                        // 1 sources

                                        catch (Exception e2) {
                                            ex = e2;
                                        }
                                        break block37;
lbl74:
                                        // 1 sources

                                        if (SimpleScheduler.__log.isDebugEnabled()) {
                                            SimpleScheduler.__log.debug((Object)("Rollbacking on " + txm + "..."));
                                        }
                                        txm.rollback();
                                    }
                                    if (ex != null && immediateRetryCount > 0) {
                                        if (SimpleScheduler.__log.isDebugEnabled()) {
                                            SimpleScheduler.__log.debug((Object)("Will retry the transaction in " + this._immediateTransactionRetryInterval + " msecs on " + this._txm + " for error: "), (Throwable)ex);
                                        }
                                        Thread.sleep(this._immediateTransactionRetryInterval);
                                    }
                                    var13_15 = null;
                                    break block35;
                                    if (SimpleScheduler.__log.isDebugEnabled()) {
                                        SimpleScheduler.__log.debug((Object)("Commiting on " + txm + "..."));
                                    }
                                    ** try [egrp 5[TRYBLOCK] [6 : 301->310)] { 
lbl88:
                                    // 1 sources

                                    txm.commit();
lbl90:
                                    // 1 sources

                                    catch (Exception e2) {
                                        ex = e2;
                                    }
                                    break block38;
                                }
                                if (SimpleScheduler.__log.isDebugEnabled()) {
                                    SimpleScheduler.__log.debug((Object)("Rollbacking on " + txm + "..."));
                                }
                                txm.rollback();
                            }
                            if (ex == null || immediateRetryCount <= 0) continue;
                            if (SimpleScheduler.__log.isDebugEnabled()) {
                                SimpleScheduler.__log.debug((Object)("Will retry the transaction in " + this._immediateTransactionRetryInterval + " msecs on " + this._txm + " for error: "), (Throwable)ex);
                            }
                            Thread.sleep(this._immediateTransactionRetryInterval);
                        }
                        break;
                    }
                    if (immediateRetryCount-- > 0) ** continue;
                    break block36;
                }
                catch (Throwable var12_19) {
                    var13_17 = null;
                    this._txm.setTransactionTimeout(0);
                    throw var12_19;
                }
            }
            this._txm.setTransactionTimeout(0);
            return e;
        }
        var13_16 = null;
        this._txm.setTransactionTimeout(0);
        throw ex;
    }

    public void setRollbackOnly() throws Exception {
        TransactionManager txm = this._txm;
        if (txm == null) {
            throw new ContextException("Cannot locate the transaction manager; the server might be shutting down.");
        }
        txm.setRollbackOnly();
    }

    public void registerSynchronizer(final Scheduler.Synchronizer synch) throws ContextException {
        TransactionManager txm = this._txm;
        if (txm == null) {
            throw new ContextException("Cannot locate the transaction manager; the server might be shutting down.");
        }
        try {
            txm.getTransaction().registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    synch.beforeCompletion();
                }

                public void afterCompletion(int status) {
                    synch.afterCompletion(status == 3);
                }
            });
        }
        catch (Exception e) {
            throw new ContextException("Unable to register synchronizer.", (Throwable)e);
        }
    }

    public String schedulePersistedJob(Scheduler.JobDetails jobDetail, Date when) throws ContextException {
        long ctime = System.currentTimeMillis();
        if (when == null) {
            when = new Date(ctime);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("scheduling " + jobDetail + " for " + when));
        }
        return this.schedulePersistedJob(new Job(when.getTime(), true, jobDetail), when, ctime);
    }

    public String scheduleMapSerializableRunnable(Scheduler.MapSerializableRunnable runnable, Date when) throws ContextException {
        long ctime = System.currentTimeMillis();
        if (when == null) {
            when = new Date(ctime);
        }
        Scheduler.JobDetails jobDetails = new Scheduler.JobDetails();
        jobDetails.getDetailsExt().put("runnable", runnable);
        runnable.storeToDetails(jobDetails);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("scheduling " + jobDetails + " for " + when));
        }
        return this.schedulePersistedJob(new Job(when.getTime(), true, jobDetails), when, ctime);
    }

    private String schedulePersistedJob(Job job, Date when, long ctime) throws ContextException {
        boolean immediate = when.getTime() <= ctime + this._immediateInterval;
        boolean nearfuture = !immediate && when.getTime() <= ctime + this._nearFutureInterval;
        try {
            if (immediate) {
                this._db.insertJob(job, this._nodeId, true);
                if (this._outstandingJobs.size() < this._todoLimit) {
                    this.addTodoOnCommit(job);
                }
                __log.debug((Object)("scheduled immediate job: " + job.jobId));
            } else if (nearfuture) {
                this._db.insertJob(job, this._nodeId, false);
                __log.debug((Object)("scheduled near-future job: " + job.jobId));
            } else {
                this._db.insertJob(job, null, false);
                __log.debug((Object)("scheduled far-future job: " + job.jobId));
            }
        }
        catch (DatabaseException dbe) {
            __log.error((Object)"Database error.", (Throwable)dbe);
            throw new ContextException("Database error.", (Throwable)dbe);
        }
        return job.jobId;
    }

    public String scheduleVolatileJob(boolean transacted, Scheduler.JobDetails jobDetail) throws ContextException {
        return this.scheduleVolatileJob(transacted, jobDetail, null);
    }

    public String scheduleVolatileJob(boolean transacted, Scheduler.JobDetails jobDetail, Date when) throws ContextException {
        long ctime = System.currentTimeMillis();
        if (when == null) {
            when = new Date(ctime);
        }
        Job job = new Job(when.getTime(), transacted, jobDetail);
        job.persisted = false;
        this.addTodoOnCommit(job);
        return job.toString();
    }

    public void setJobProcessor(Scheduler.JobProcessor processor) throws ContextException {
        this._jobProcessor = processor;
    }

    public void shutdown() {
        this.stop();
        this._jobProcessor = null;
        this._txm = null;
        this._todo = null;
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        if (this._exec == null) {
            this._exec = Executors.newCachedThreadPool();
        }
        this._todo.clearTasks(UpgradeJobsTask.class);
        this._todo.clearTasks(LoadImmediateTask.class);
        this._todo.clearTasks(CheckStaleNodes.class);
        this._processedSinceLastLoadTask.clear();
        this._outstandingJobs.clear();
        this._knownNodes.clear();
        try {
            this.execTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SimpleScheduler.this._knownNodes.addAll(SimpleScheduler.this._db.getNodeIds());
                    return null;
                }
            });
        }
        catch (Exception ex) {
            __log.error((Object)"Error retrieving node list.", (Throwable)ex);
            throw new ContextException("Error retrieving node list.", (Throwable)ex);
        }
        long now = System.currentTimeMillis();
        for (String s : this._knownNodes) {
            this._lastHeartBeat.put(s, now);
        }
        this._todo.enqueue(new LoadImmediateTask(now));
        this._todo.enqueue(new CheckStaleNodes(now + this.randomMean(this._staleInterval)));
        this._todo.enqueue(new UpgradeJobsTask(now + this.randomMean(this._immediateInterval)));
        this._todo.start();
        this._running = true;
    }

    private long randomMean(long mean) {
        return (long)this._random.nextDouble() * mean + mean / 2L;
    }

    public synchronized void stop() {
        if (!this._running) {
            return;
        }
        this._todo.stop();
        this._todo.clearTasks(UpgradeJobsTask.class);
        this._todo.clearTasks(LoadImmediateTask.class);
        this._todo.clearTasks(CheckStaleNodes.class);
        this._processedSinceLastLoadTask.clear();
        this._outstandingJobs.clear();
        this._running = false;
    }

    protected void runJob(Job job) {
        this._exec.submit(new RunJob(job, this._jobProcessor));
    }

    protected void runPolledRunnable(Job job) {
        this._exec.submit(new RunJob(job, this._polledRunnableProcessor));
    }

    private void addTodoOnCommit(final Job job) {
        this.registerSynchronizer(new Scheduler.Synchronizer(){

            public void afterCompletion(boolean success) {
                if (success) {
                    SimpleScheduler.this.enqueue(job);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    public boolean isTransacted() {
        TransactionManager txm = this._txm;
        if (txm == null) {
            throw new ContextException("Cannot locate the transaction manager; the server might be shutting down.");
        }
        try {
            Transaction tx = txm.getTransaction();
            return tx != null && tx.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new ContextException("Internal Error: Could not obtain transaction status.");
        }
    }

    @Override
    public void runTask(final Task task) {
        if (task instanceof Job) {
            Job job = (Job)task;
            if (job.detail.getDetailsExt().get("runnable") != null) {
                this.runPolledRunnable(job);
            } else {
                this.runJob(job);
            }
        } else if (task instanceof SchedulerTask) {
            this._exec.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        ((SchedulerTask)task).run();
                    }
                    catch (Exception ex) {
                        __log.error((Object)"Error during SchedulerTask execution", (Throwable)ex);
                    }
                    return null;
                }
            });
        }
    }

    public void updateHeartBeat(String nodeId) {
        if (nodeId == null) {
            return;
        }
        if (this._nodeId.equals(nodeId)) {
            return;
        }
        this._lastHeartBeat.put(nodeId, System.currentTimeMillis());
        this._knownNodes.add(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doLoadImmediate() {
        boolean bl;
        int batch;
        block14: {
            __log.debug((Object)"LOAD IMMEDIATE started");
            if (this._outstandingJobs.size() > this._todoLimit / 2) {
                return true;
            }
            batch = Math.min((int)(this._immediateInterval * (long)this._tps / 1000L), this._todoLimit - this._outstandingJobs.size());
            if (batch > 0) break block14;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Max capacity reached: " + this._outstandingJobs.size() + " jobs dispacthed i.e. queued or being executed"));
            }
            boolean bl2 = true;
            Object var11_6 = null;
            __log.debug((Object)"LOAD IMMEDIATE complete");
            return bl2;
        }
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("loading " + batch + " jobs from db"));
            }
            List<Job> jobs = this.execTransaction(new Callable<List<Job>>(){

                @Override
                public List<Job> call() throws Exception {
                    return SimpleScheduler.this._db.dequeueImmediate(SimpleScheduler.this._nodeId, System.currentTimeMillis() + SimpleScheduler.this._immediateInterval, batch);
                }
            });
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("loaded " + jobs.size() + " jobs from db"));
            }
            long delayedTime = System.currentTimeMillis() - this._warningDelay;
            int delayedCount = 0;
            AbsoluteTimeDateFormat f = new AbsoluteTimeDateFormat();
            for (Job j : jobs) {
                boolean runningLate;
                if (this._outstandingJobs.size() >= this._todoLimit) {
                    if (!__log.isDebugEnabled()) break;
                    __log.debug((Object)("Max capacity reached: " + this._outstandingJobs.size() + " jobs dispacthed i.e. queued or being executed"));
                    break;
                }
                boolean bl3 = runningLate = j.schedDate <= delayedTime;
                if (runningLate) {
                    ++delayedCount;
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("todo.enqueue job from db: " + j.jobId.trim() + " for " + j.schedDate + "(" + f.format((Object)j.schedDate) + ") " + (runningLate ? " delayed=true" : "")));
                }
                this.enqueue(j);
            }
            if (delayedCount > 0) {
                __log.warn((Object)("Dispatching jobs with more than " + this._warningDelay / 60000L + " minutes delay. Either the server was down for some time or the job load is greater than available capacity"));
            }
            this._processedSinceLastLoadTask.clear();
            bl = true;
            Object var11_7 = null;
        }
        catch (Exception ex) {
            boolean bl4;
            try {
                __log.error((Object)"Error loading immediate jobs from database.", (Throwable)ex);
                bl4 = false;
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                __log.debug((Object)"LOAD IMMEDIATE complete");
                throw throwable;
            }
            __log.debug((Object)"LOAD IMMEDIATE complete");
            return bl4;
        }
        __log.debug((Object)"LOAD IMMEDIATE complete");
        return bl;
    }

    void enqueue(Job job) {
        if (this._processedSinceLastLoadTask.get(job.jobId) == null) {
            if (this._outstandingJobs.putIfAbsent(job.jobId, job.schedDate) == null) {
                if (job.schedDate <= System.currentTimeMillis()) {
                    this.runJob(job);
                } else {
                    this._todo.enqueue(job);
                }
            } else if (__log.isDebugEnabled()) {
                __log.debug((Object)("Job " + job.jobId + " is being processed (outstanding job)"));
            }
        } else if (__log.isDebugEnabled()) {
            __log.debug((Object)("Job " + job.jobId + " is being processed (processed since last load)"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doUpgrade() {
        boolean bl;
        __log.debug((Object)"UPGRADE started");
        final ArrayList<String> knownNodes = new ArrayList<String>(this._knownNodes);
        knownNodes.add(this._nodeId);
        Collections.sort(knownNodes);
        final long maxtime = System.currentTimeMillis() + this._nearFutureInterval;
        try {
            bl = this.execTransaction(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    int numNodes = knownNodes.size();
                    for (int i = 0; i < numNodes; ++i) {
                        String node = (String)knownNodes.get(i);
                        SimpleScheduler.this._db.updateAssignToNode(node, i, numNodes, maxtime);
                    }
                    return true;
                }
            });
            Object var7_5 = null;
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                __log.error((Object)"Database error upgrading jobs.", (Throwable)ex);
                bl2 = false;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                __log.debug((Object)"UPGRADE complete");
                throw throwable;
            }
            __log.debug((Object)"UPGRADE complete");
            return bl2;
        }
        __log.debug((Object)"UPGRADE complete");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void recoverStaleNode(final String nodeId) {
        __log.debug((Object)("recovering stale node " + nodeId));
        try {
            try {
                int numrows = this.execTransaction(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return SimpleScheduler.this._db.updateReassign(nodeId, SimpleScheduler.this._nodeId);
                    }
                });
                __log.debug((Object)("reassigned " + numrows + " jobs to self. "));
                this._knownNodes.remove(nodeId);
                this._lastHeartBeat.remove(nodeId);
                this.doLoadImmediate();
            }
            catch (Exception ex) {
                __log.error((Object)"Database error reassigning node.", (Throwable)ex);
                Object var4_5 = null;
                __log.debug((Object)"node recovery complete");
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            __log.debug((Object)"node recovery complete");
            throw throwable;
        }
        __log.debug((Object)"node recovery complete");
    }

    private class CheckStaleNodes
    extends SchedulerTask {
        CheckStaleNodes(long schedDate) {
            super(schedDate);
        }

        public void run() {
            SimpleScheduler.this._todo.enqueue(new CheckStaleNodes(System.currentTimeMillis() + SimpleScheduler.this._staleInterval));
            __log.debug((Object)"CHECK STALE NODES started");
            for (String nodeId : SimpleScheduler.this._knownNodes) {
                Long lastSeen = (Long)SimpleScheduler.this._lastHeartBeat.get(nodeId);
                if (lastSeen != null && System.currentTimeMillis() - lastSeen <= SimpleScheduler.this._staleInterval || SimpleScheduler.this._nodeId.equals(nodeId)) continue;
                SimpleScheduler.this.recoverStaleNode(nodeId);
            }
        }
    }

    private class UpgradeJobsTask
    extends SchedulerTask {
        UpgradeJobsTask(long schedDate) {
            super(schedDate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long ctime = System.currentTimeMillis();
            long ntime = SimpleScheduler.this._nextUpgrade.get();
            __log.debug((Object)("UPGRADE task for " + this.schedDate + " fired at " + ctime));
            if (SimpleScheduler.this._nextUpgrade.get() > System.currentTimeMillis()) {
                __log.debug((Object)("UPGRADE skipped -- wait another " + (ntime - ctime) + "ms"));
                SimpleScheduler.this._todo.enqueue(new UpgradeJobsTask(ntime));
                return;
            }
            boolean success = false;
            try {
                success = SimpleScheduler.this.doUpgrade();
            }
            catch (Throwable throwable) {
                long future = System.currentTimeMillis() + (success ? (long)((double)SimpleScheduler.this._nearFutureInterval * 0.5) : 1000L);
                SimpleScheduler.this._nextUpgrade.set(future);
                SimpleScheduler.this._todo.enqueue(new UpgradeJobsTask(future));
                __log.debug((Object)("UPGRADE completed, success = " + success + "; next time in " + (future - ctime) + "ms"));
                throw throwable;
            }
            long future = System.currentTimeMillis() + (success ? (long)((double)SimpleScheduler.this._nearFutureInterval * 0.5) : 1000L);
            SimpleScheduler.this._nextUpgrade.set(future);
            SimpleScheduler.this._todo.enqueue(new UpgradeJobsTask(future));
            __log.debug((Object)("UPGRADE completed, success = " + success + "; next time in " + (future - ctime) + "ms"));
        }
    }

    private class LoadImmediateTask
    extends SchedulerTask {
        LoadImmediateTask(long schedDate) {
            super(schedDate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean success = false;
            try {
                success = SimpleScheduler.this.doLoadImmediate();
            }
            finally {
                if (success) {
                    SimpleScheduler.this._todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + (long)((double)SimpleScheduler.this._immediateInterval * 0.9)));
                } else {
                    SimpleScheduler.this._todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + 1000L));
                }
            }
        }
    }

    private abstract class SchedulerTask
    extends Task
    implements Runnable {
        SchedulerTask(long schedDate) {
            super(schedDate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RunJob
    implements Callable<Void> {
        final Job job;
        final Scheduler.JobProcessor processor;

        RunJob(Job job, Scheduler.JobProcessor processor) {
            this.job = job;
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                final Scheduler.JobInfo jobInfo = new Scheduler.JobInfo(this.job.jobId, this.job.detail, this.job.detail.getRetryCount().intValue());
                if (this.job.transacted) {
                    final boolean[] needRetry = new boolean[]{true};
                    try {
                        SimpleScheduler.this.execTransaction(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                if (RunJob.this.job.persisted && !SimpleScheduler.this._db.deleteJob(RunJob.this.job.jobId, SimpleScheduler.this._nodeId)) {
                                    throw new JobNoLongerInDbException(RunJob.this.job.jobId, SimpleScheduler.this._nodeId);
                                }
                                try {
                                    RunJob.this.processor.onScheduledJob(jobInfo);
                                    if (RunJob.this.job.detail.getDetailsExt().get("runnable") != null && !"COMPLETED".equals(String.valueOf(jobInfo.jobDetail.getDetailsExt().get("runnable_status")))) {
                                        if (SimpleScheduler.this._pollIntervalForPolledRunnable < 0L) {
                                            if (__log.isWarnEnabled()) {
                                                __log.warn((Object)"The poll interval for polled runnables is negative; setting it to 1000ms");
                                            }
                                            SimpleScheduler.this._pollIntervalForPolledRunnable = 1000L;
                                        }
                                        RunJob.this.job.schedDate = System.currentTimeMillis() + SimpleScheduler.this._pollIntervalForPolledRunnable;
                                        SimpleScheduler.this._db.insertJob(RunJob.this.job, SimpleScheduler.this._nodeId, false);
                                    }
                                }
                                catch (Scheduler.JobProcessorException jpe) {
                                    if (!jpe.retry) {
                                        needRetry[0] = false;
                                    }
                                    throw jpe;
                                }
                                return null;
                            }
                        });
                    }
                    catch (JobNoLongerInDbException jde) {
                        __log.debug((Object)("job no longer in db forced rollback: " + this.job));
                    }
                    catch (Exception ex) {
                        __log.error((Object)("Error while processing a " + (this.job.persisted ? "" : "non-") + "persisted job" + (needRetry[0] && this.job.persisted ? ": " : ", no retry: ") + this.job), (Throwable)ex);
                        if (this.job.persisted) {
                            SimpleScheduler.this.execTransaction(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    if (needRetry[0]) {
                                        int retry = RunJob.this.job.detail.getRetryCount() + 1;
                                        if (retry <= 10) {
                                            RunJob.this.job.detail.setRetryCount(Integer.valueOf(retry));
                                            long delay = (long)Math.pow(5.0, retry);
                                            RunJob.this.job.schedDate = System.currentTimeMillis() + delay * 1000L;
                                            SimpleScheduler.this._db.updateJob(RunJob.this.job);
                                            __log.error((Object)("Error while processing job, retrying in " + delay + "s"));
                                        } else {
                                            SimpleScheduler.this._db.deleteJob(RunJob.this.job.jobId, SimpleScheduler.this._nodeId);
                                            __log.error((Object)("Error while processing job after 10 retries, no more retries:" + RunJob.this.job));
                                        }
                                    } else {
                                        SimpleScheduler.this._db.deleteJob(RunJob.this.job.jobId, SimpleScheduler.this._nodeId);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                } else {
                    this.processor.onScheduledJob(jobInfo);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                SimpleScheduler.this._processedSinceLastLoadTask.put(this.job.jobId, this.job.schedDate);
                SimpleScheduler.this._outstandingJobs.remove(this.job.jobId);
            }
        }
    }
}

