/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tck.spec.mapper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import org.jboss.tck.spec.audit.Assertion;
import org.jboss.tck.spec.audit.Group;
import org.jboss.tck.spec.audit.Section;
import org.jboss.tck.spec.audit.SectionElement;
import org.jboss.tck.spec.audit.Test;
import org.jboss.tck.spec.mapper.TckAuditSaxParser;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Mapper {
    private String script = "<script>\nfunction changeVisibility(divId, hrefId)\n{\n var divElement = document.getElementById(divId);\n var hrefElement = document.getElementById(hrefId); if(divElement.style.display == 'none') {\n   divElement.style.display=\"block\";\n   hrefElement.innerHTML = '<img src=\"images/minus.png\"/>';\n } else {\n   divElement.style.display=\"none\";\n   hrefElement.innerHTML = '<img src=\"images/plus.png\"/>';\n }}\n</script>";
    private Document specHtml;
    private Document coverageHtml;
    private TckAuditSaxParser auditParser;
    private List<Section> auditSections;
    private String tckVersion;
    private static final Logger log = Logger.getLogger(Mapper.class.getName());
    private static final String SPEC_WITH_ASSERTIONS = System.getProperty("new.spec.filename", "spec-with-assertions.html");
    private static final String TCK_XML_AUDIT_URL = System.getProperty("tck.audit.url");
    private static final String COVERAGE_REPORT_HTML_URL = System.getProperty("tck.coverage.url");
    private static final String SPEC_HTML_PATH = System.getProperty("spec.html.path");
    private static final String TCK_VERSION = System.getProperty("tck.version");

    public Mapper(String tckAuditURL, String coverageReportURL, String pathToCdiSpec, String tckVersion) {
        this.auditParser = new TckAuditSaxParser(tckAuditURL);
        this.tckVersion = tckVersion;
        try {
            this.specHtml = Jsoup.parse(new File(pathToCdiSpec), "utf-8");
        }
        catch (IOException e) {
            new Exception("Cannot find " + pathToCdiSpec + " :" + e.getStackTrace().toString());
        }
        try {
            this.coverageHtml = Jsoup.connect(coverageReportURL).maxBodySize(0).timeout(0).get();
        }
        catch (IOException e) {
            new Exception("Cannot find " + coverageReportURL + " :" + e.getStackTrace().toString());
        }
    }

    private void parseTckXmlAudit() {
        this.auditParser.parseDocument();
        this.auditSections = this.auditParser.getSections();
    }

    private void parseCoverageHtml() {
        for (Section section : this.auditSections) {
            if (section.getSectionElements().isEmpty()) continue;
            Element sectionElement = this.coverageHtml.getElementById(section.getTitle());
            if (sectionElement != null) {
                Elements assertionTextElements = sectionElement.select("div[class=results]");
                for (SectionElement auditSectionElement : section.getSectionElements()) {
                    if (auditSectionElement instanceof Assertion) {
                        Assertion assertion = (Assertion)auditSectionElement;
                        this.compareAssertionToElements(assertion, assertionTextElements);
                        continue;
                    }
                    for (Assertion assertion : ((Group)auditSectionElement).getAssertions()) {
                        this.compareAssertionToElements(assertion, assertionTextElements);
                    }
                }
                continue;
            }
            log.warning("Section " + sectionElement + " cannot be found!");
        }
    }

    private void writeToSpec() {
        this.specHtml.select("head").after(this.script);
        Element styleElement = this.specHtml.select("style").first();
        styleElement.append(".assertionsDiv {background-color: #F2FAF2; display: block; padding: 10pt 10pt 5pt 10pt; \n}.groupAssertion { padding-left:15pt }\n.notTestableAssertion { background-color: #E1F0FF; }\n.assertionTest { font-family: monospace; }");
        for (Section section : this.auditSections) {
            if (section.getSectionElements().isEmpty()) continue;
            Element sectionElement = this.specHtml.getElementById(section.getId());
            String wrapDivId = "assertions" + section.getId();
            String hrefId = "href" + section.getId();
            if (sectionElement != null) {
                sectionElement.after("<div id=" + wrapDivId + " class=\"assertionsDiv\"></div>");
                sectionElement.after("<p><a id=" + hrefId + " onclick=\"changeVisibility('" + wrapDivId + "', '" + hrefId + "')\";\"><img src=\"images/minus.png\"/></a> TCK assertions</p>");
                Element wrapDiv = sectionElement.parent().getElementById(wrapDivId);
                for (SectionElement auditSectionElement : section.getSectionElements()) {
                    if (auditSectionElement instanceof Assertion) {
                        Assertion assertion = (Assertion)auditSectionElement;
                        this.writeAssertionToDivElement(assertion, wrapDiv);
                        continue;
                    }
                    Group group = (Group)auditSectionElement;
                    wrapDiv.append("<p>" + group.getText() + "</p>");
                    for (Assertion assertion : group.getAssertions()) {
                        this.writeAssertionToDivElement(assertion, wrapDiv);
                    }
                }
                continue;
            }
            log.warning("Section " + sectionElement + " cannot be found!");
        }
        try {
            FileOutputStream fileInputStream = new FileOutputStream(new File(SPEC_WITH_ASSERTIONS));
            fileInputStream.write(this.specHtml.toString().getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String adjustAssertionText(Assertion assertion) {
        StringBuilder strBuild = new StringBuilder(assertion.getGroup() != null ? "<p class=\"groupAssertion\">" : "<p>");
        strBuild.append(assertion.isTestable() ? "" : "<p class=\"notTestableAssertion\">");
        strBuild.append("<strong>" + assertion.getId().concat(") </strong>"));
        strBuild.append(assertion.getText().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        if (!assertion.isTestable() && assertion.getNote() != null) {
            strBuild.append("<br>Note: <i>" + assertion.getNote() + "</i></br>");
        }
        strBuild.append("</p>");
        return strBuild.toString();
    }

    private void compareAssertionToElements(Assertion assertion, Elements assertionTextElements) {
        for (Element assertionTextElement : assertionTextElements) {
            String assertionAudit;
            String assertionElement = assertionTextElement.text().replace("|", "");
            if (!assertionElement.contains(assertionAudit = assertion.getText().trim().replaceAll("\\s+", " "))) continue;
            Elements coverageElements = assertionTextElement.select("div[class=coverageMethod");
            String testPackageName = assertionTextElement.select("div[class=packageName]").text();
            for (Element coverageElement : coverageElements) {
                String test = coverageElement.text().replace("github", "");
                try {
                    URL url = new URL(coverageElement.select("a").attr("href"));
                    url = new URL(url.toString().replace("master", this.tckVersion));
                    assertion.getTests().add(new Test(test, url, testPackageName));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void writeAssertionToDivElement(Assertion assertion, Element wrapDiv) {
        String assertionText = this.adjustAssertionText(assertion);
        wrapDiv.append(assertionText);
        if (!assertion.getTests().isEmpty()) {
            wrapDiv.append(assertion.getGroup() != null ? "<ul class=\"groupAssertion\" id=" + assertion.getId() + ">" : "<ul id=" + assertion.getId() + ">");
            for (Test test : assertion.getTests()) {
                String testClassName = test.getTestMethodName().substring(0, test.getTestMethodName().indexOf("."));
                String testMethodName = test.getTestMethodName().substring(test.getTestMethodName().indexOf("."));
                String listItem = "<li class=\"assertionTest\"><a target=\"_blank\" href=" + test.getRefUrl() + ">" + testClassName + "</a>" + testMethodName + "</li>";
                wrapDiv.select("ul[id=" + assertion.getId()).append(listItem);
            }
        }
    }

    public static void main(String[] args) {
        log.addHandler(new ConsoleHandler());
        log.info("Starting TCK assertions mapper.");
        Mapper.checkProperties();
        Mapper mapper = new Mapper(TCK_XML_AUDIT_URL, COVERAGE_REPORT_HTML_URL, SPEC_HTML_PATH, TCK_VERSION);
        mapper.parseTckXmlAudit();
        mapper.parseCoverageHtml();
        mapper.writeToSpec();
        log.info("TCK assertions mapper succesfully finished.");
    }

    private static void checkProperties() {
        if (TCK_XML_AUDIT_URL == null || TCK_XML_AUDIT_URL.isEmpty()) {
            log.severe("tck.audit.url system property was not defined!");
            System.exit(1);
        }
        if (COVERAGE_REPORT_HTML_URL == null || COVERAGE_REPORT_HTML_URL.isEmpty()) {
            log.severe("tck.coverage.url system property was not defined!");
            System.exit(1);
        }
        if (SPEC_HTML_PATH == null || SPEC_HTML_PATH.isEmpty()) {
            log.severe("spec.html.path system property was not defined!");
            System.exit(1);
        }
        if (TCK_VERSION == null || TCK_VERSION.isEmpty()) {
            log.severe("tck.version system property was not defined!");
            System.exit(1);
        }
    }
}

