package org.jboss.testharness.api;

import java.io.IOException;
import java.lang.reflect.Method;

/**
 * Allow the TCK to launch a test remotely in a container.
 * 
 * The TCK provides a built in launcher for use in an environment where Servlet
 * is available such as EE6, EE5 or EE6 Web Profile. This can be used by 
 * specifying:
 * 
 * org.jboss.jsr299.tck.api.TestLauncher=org.jboss.jsr299.tck.impl.runner.servlet.ServletTestLauncher
 * 
 * A Servlet suitable for launching tests is included in the artifacts produced
 * by the JSR299 TCK.
 * 
 * @author Pete Muir
 *
 */
public interface TestLauncher
{
   
   public static final String PROPERTY_NAME = TestLauncher.class.getName();
   
   /**
    * Launch a test remotely, returning the result to the TCK.
    * 
    * @param method
    *           the method to launch
    * @return the test result
    * @throws IOException
    *            if a communication error occured with the server. This will
    *            cause the test to fail
    */
   public TestResult launchTest(Method method) throws IOException;
   
}
