package org.jboss.testharness.api;

/**
 * Wraps the deployment exception, which can be obtained using
 * {@link #getCause()} also providing contextual information on the deployment
 * 
 * @author Pete Muir
 * 
 */
public class DeploymentException extends Exception
{

   private final String name;

   public DeploymentException(String name)
   {
      super();
      this.name = name;
   }

   public DeploymentException(String name, String message, Throwable cause)
   {
      super(message, cause);
      this.name = name;
   }

   public DeploymentException(String name, String message)
   {
      super(name);
      this.name = name;
   }

   public DeploymentException(String name, Throwable cause)
   {
      super(cause);
      this.name = name;
   }

   public DeploymentException(DeploymentException deploymentException, Throwable cause)
   {
      super(deploymentException.getMessage(), cause);
      this.name = deploymentException.getName();
   }

   /**
    * Get the deployment identifier
    * 
    * @return the name
    */
   public String getName()
   {
      return name;
   }

}
