/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.integration.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.helpers.AbstractContainerConnector;

public class TomcatConnector
extends AbstractContainerConnector
implements Containers {
    private static final Logger log = Logger.getLogger(TomcatConnector.class);
    private static final String SERVER_HOME_PROPERTY_NAME = "tomcat.home";
    private String binDirectory;
    private final File tmpdir;
    private final HttpClient client;

    public TomcatConnector() throws IOException {
        log.info((Object)"You must add the the tests/secret user to Tomcat, for example, in $CATALINA_BASE/conf/tomcat-users.xml add <user name=\"tests\" password=\"secret\" roles=\"standard,manager\" />");
        this.tmpdir = new File(System.getProperty("java.io.tmpdir"), "org.jboss.webbeans.tck.integration.jbossas");
        this.tmpdir.mkdir();
        this.tmpdir.deleteOnExit();
        this.client = new HttpClient();
        this.client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("tests", "secret");
        this.client.getState().setCredentials(new AuthScope(null, 8080, null), (Credentials)credentials);
    }

    protected String getServerHomePropertyName() {
        return SERVER_HOME_PROPERTY_NAME;
    }

    protected void shutdownServer() throws IOException {
        this.launch(this.getBinDirectory(), "shutdown", "");
    }

    protected void startServer() throws IOException {
        this.launch(this.getBinDirectory(), "startup", "");
    }

    protected String getBinDirectory() {
        if (this.binDirectory == null) {
            this.binDirectory = new File(this.getServerDirectory() + "/bin").getPath();
        }
        return this.binDirectory;
    }

    protected String getLogName() {
        return "tomcat.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(InputStream stream, String name) throws DeploymentException, IOException {
        String deployUrl = this.getManagerUrl("deploy", "path=/" + this.getContextName(name), "update=true");
        PutMethod put = new PutMethod(deployUrl);
        put.setRequestEntity((RequestEntity)new InputStreamRequestEntity(stream));
        try {
            int status = this.client.executeMethod((HttpMethod)put);
            if (status != 200) {
                throw new DeploymentException(new String(put.getResponseBody()));
            }
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String name) throws IOException {
        String deployUrl = this.getManagerUrl("undeploy", "path=/" + this.getContextName(name));
        GetMethod get = new GetMethod(deployUrl);
        try {
            int status = this.client.executeMethod((HttpMethod)get);
            if (status != 200) {
                throw new IllegalStateException(new String(get.getResponseBody()));
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    protected String getManagerUrl(String command, String ... parameters) {
        String url = this.getHttpUrl() + "manager/" + command;
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i];
            url = i == 0 ? url + "?" + parameter : url + "&" + parameter;
        }
        return url;
    }

    protected String getContextName(String name) {
        return name.substring(0, name.length() - 4);
    }
}

