/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl;

import org.jboss.testharness.api.Configurable;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ConfigurationBuilder;
import org.jboss.testharness.api.TestLauncher;
import org.jboss.testharness.impl.util.DeploymentProperties;
import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.StandaloneContainers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesBasedConfigurationBuilder<T extends Configuration>
implements ConfigurationBuilder {
    private final DeploymentProperties deploymentProperties = new DeploymentProperties();
    private final T configuration;

    public PropertiesBasedConfigurationBuilder(T configuration) {
        this.configuration = configuration;
        configuration.setOutputDirectory(this.deploymentProperties.getStringValue("org.jboss.testharness.outputDirectory", Configuration.DEFAULT_OUTPUT_DIRECTORY, false));
        configuration.setStandalone(this.deploymentProperties.getBooleanValue("org.jboss.testharness.standalone", true, false));
        configuration.setRunIntegrationTests(this.deploymentProperties.getBooleanValue("org.jboss.testharness.runIntegrationTests", false, false));
        configuration.setConnectTimeout(this.deploymentProperties.getIntValue("org.jboss.testharness.connectTimeout", 5000, false));
        configuration.setLibraryDirectory(this.deploymentProperties.getStringValue("org.jboss.testharness.libraryDirectory", Configuration.DEFAULT_LIBRARY_DIRECTORY, false));
        configuration.setHost(this.deploymentProperties.getStringValue("org.jboss.testharness.host", "localhost:8080", false));
        configuration.setTestPackage(this.deploymentProperties.getStringValue("org.jboss.testharness.testPackage", null, false));
    }

    public ConfigurationBuilder init() {
        this.configuration.setInContainerTestLauncher(this.getInstanceValue(TestLauncher.PROPERTY_NAME, TestLauncher.class, this.configuration.isRunIntegrationTests() || !this.configuration.isStandalone()));
        this.configuration.setContainers(this.getInstanceValue(Containers.PROPERTY_NAME, Containers.class, !this.configuration.isStandalone() || this.configuration.isRunIntegrationTests()));
        this.configuration.setStandaloneContainers(this.getInstanceValue(StandaloneContainers.PROPERTY_NAME, StandaloneContainers.class, this.configuration.isStandalone()));
        return this;
    }

    protected <T> T getInstanceValue(String propertyName, Class<T> expectedType, boolean required) {
        T instance = this.deploymentProperties.getInstanceValue(propertyName, expectedType, required);
        if (instance instanceof Configurable) {
            ((Configurable)instance).setConfiguration(this.configuration);
        }
        return instance;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    protected DeploymentProperties getDeploymentProperties() {
        return this.deploymentProperties;
    }
}

