/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ArtifactScanner;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.ExpectedDeploymentException;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.ear.EarArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr299.TCKArtifactDescriptor;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactGenerator {
    private static final Logger log = Logger.getLogger(ArtifactGenerator.class);
    private final Configuration configuration;

    public ArtifactGenerator(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
    }

    public List<ArtifactDescriptor> createArtifacts(String packageName) {
        HashSet classes = new HashSet();
        classes.addAll(new ArtifactScanner(packageName, null).getClasses());
        ArrayList<ArtifactDescriptor> artifacts = new ArrayList<ArtifactDescriptor>();
        for (Class clazz : classes) {
            artifacts.add(this.createArtifact(clazz));
        }
        return artifacts;
    }

    public void dumpArtifacts(String basePackageName) {
        List<ArtifactDescriptor> artifacts = this.createArtifacts(basePackageName);
        File file = new File(this.configuration.getOutputDirectory());
        if (!file.exists()) {
            file.mkdirs();
        } else if (file.isFile()) {
            throw new IllegalStateException("Cannot use debug directory " + this.configuration.getOutputDirectory() + ", it already exists");
        }
        log.info((Object)("Writing artifacts to " + this.configuration.getOutputDirectory()));
        for (ArtifactDescriptor artifact : artifacts) {
            try {
                artifact.writeArtifactToDisk(this.configuration.getOutputDirectory());
                log.info((Object)("Written artifact to disk " + artifact));
            }
            catch (IOException e) {
                log.warn((Object)("Error writing artifact to disk " + artifact), (Throwable)e);
            }
        }
    }

    public TCKArtifactDescriptor createArtifact(Class<?> declaringClass) {
        if (declaringClass.isAnnotationPresent(Artifact.class)) {
            return new ArtifactProcessor(declaringClass, this.configuration.isStandalone(), this.configuration.getLibraryDirectory()).createArtifact();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactProcessor {
        private static final Logger log = Logger.getLogger(ArtifactProcessor.class);
        private final boolean unit;
        private final boolean runLocally;
        private final boolean addDeclaringPackage;
        private final String beansXml;
        private final PackagingType packagingType;
        private final Collection<ResourceDescriptor> resources;
        private final Collection<Class<?>> classes;
        private final Class<? extends Throwable> expectedDeploymentException;
        private final Set<ResourceDescriptor> extraLibraries;
        private final Class<?> declaringClass;
        private final boolean standalone;

        public ArtifactProcessor(Class<?> declaringClass, boolean standalone, String extraLibrariesDirectory) {
            this.standalone = standalone;
            this.declaringClass = declaringClass;
            if (!declaringClass.isAnnotationPresent(Artifact.class)) {
                throw new IllegalStateException("Unable to find @Artifact on " + declaringClass);
            }
            this.addDeclaringPackage = declaringClass.getAnnotation(Artifact.class).addCurrentPackage();
            this.beansXml = declaringClass.isAnnotationPresent(BeansXml.class) ? this.asAbsolutePath(declaringClass.getAnnotation(BeansXml.class).value()) : null;
            this.packagingType = declaringClass.isAnnotationPresent(Packaging.class) ? declaringClass.getAnnotation(Packaging.class).value() : PackagingType.WAR;
            if (declaringClass.isAnnotationPresent(IntegrationTest.class)) {
                this.unit = false;
                this.runLocally = declaringClass.getAnnotation(IntegrationTest.class).runLocally();
            } else {
                this.unit = true;
                this.runLocally = false;
            }
            this.resources = declaringClass.isAnnotationPresent(Resources.class) ? this.asResourceDescriptors(declaringClass.getAnnotation(Resources.class).value()) : Collections.emptyList();
            this.classes = declaringClass.isAnnotationPresent(Classes.class) ? Arrays.asList(declaringClass.getAnnotation(Classes.class).value()) : Collections.emptyList();
            this.expectedDeploymentException = declaringClass.isAnnotationPresent(ExpectedDeploymentException.class) ? declaringClass.getAnnotation(ExpectedDeploymentException.class).value() : null;
            if (extraLibrariesDirectory != null) {
                File directory = new File(extraLibrariesDirectory);
                this.extraLibraries = new HashSet<ResourceDescriptor>();
                if (directory.isDirectory()) {
                    for (File file : directory.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    })) {
                        try {
                            this.extraLibraries.add(new ResourceDescriptorImpl(file.getName(), file.toURI().toURL()));
                        }
                        catch (IOException e) {
                            log.warn((Object)"Unable to load extra library", (Throwable)e);
                        }
                    }
                }
            } else {
                this.extraLibraries = Collections.emptySet();
            }
        }

        public TCKArtifactDescriptor createArtifact() {
            TCKArtifactDescriptor artifact = ArtifactProcessor.newArtifact(this.packagingType, this.declaringClass, this.beansXml, this.standalone, this.addDeclaringPackage);
            artifact.setUnit(this.unit);
            artifact.setRunLocally(this.runLocally);
            artifact.setExpectedDeploymentException(this.expectedDeploymentException);
            artifact.getClasses().addAll(this.classes);
            artifact.getResources().removeAll(this.resources);
            artifact.getResources().addAll(this.resources);
            artifact.getLibraries().addAll(this.extraLibraries);
            return artifact;
        }

        private Collection<ResourceDescriptor> asResourceDescriptors(Resource[] resources) {
            ArrayList<ResourceDescriptor> resourceDescriptorImpls = new ArrayList<ResourceDescriptor>();
            for (Resource resource : resources) {
                resourceDescriptorImpls.add(new ResourceDescriptorImpl(resource.destination(), this.asAbsolutePath(resource.source())));
            }
            return resourceDescriptorImpls;
        }

        private String asAbsolutePath(String path) {
            if (path.startsWith("/")) {
                return path.substring(1);
            }
            return this.declaringClass.getPackage().getName().replace(".", "/") + "/" + path;
        }

        private static TCKArtifactDescriptor newArtifact(PackagingType packagingType, Class<?> declaringClass, String beansXml, boolean standalone, boolean addDeclaringPackage) {
            JSR299ArtifactDescriptor artifact = !standalone && packagingType.equals((Object)PackagingType.WAR) ? new WarArtifactDescriptor(declaringClass, beansXml).initialize() : (!standalone && packagingType.equals((Object)PackagingType.EAR) ? new EarArtifactDescriptor(declaringClass, beansXml).initialize() : new JSR299ArtifactDescriptor(declaringClass, beansXml).initialize());
            if (addDeclaringPackage) {
                artifact.addPackage(declaringClass.getPackage());
            }
            return artifact;
        }

        public boolean isUnit() {
            return this.unit;
        }
    }
}

