/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging.jsr299;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.jboss.testharness.impl.ConfigurationImpl;
import org.jboss.testharness.impl.packaging.ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCKArtifactDescriptor
extends ArtifactDescriptor {
    private static final Logger log = Logger.getLogger(TCKArtifactDescriptor.class);
    private boolean unit;
    private boolean runLocally;
    private Class<? extends Throwable> expectedDeploymentException;

    public TCKArtifactDescriptor(Class<?> declaringClass) {
        super(declaringClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCKArtifactDescriptor initialize() {
        super.initialize();
        if (this.isLibrariesSupported()) {
            this.getLibraries().add(new ResourceDescriptorImpl("testng.jar", "/lib/testng-jdk15.jar"));
            this.getLibraries().add(new ResourceDescriptorImpl("jboss-test-harness-api.jar", "/lib/jboss-test-harness-api.jar"));
            this.getLibraries().add(new ResourceDescriptorImpl("jboss-test-harness.jar", "/lib/jboss-test-harness.jar"));
            InputStream deploymentProperties = null;
            try {
                deploymentProperties = TCKArtifactDescriptor.getDeploymentProperties(this.getDeclaringClass());
                this.getResources().add(new ResourceDescriptorImpl(this.getClassesRoot() + "META-INF/web-beans-tck.properties", deploymentProperties));
            }
            catch (IOException e) {
                log.warn((Object)"Error generating deployment properties", (Throwable)e);
            }
            finally {
                if (deploymentProperties != null) {
                    try {
                        deploymentProperties.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error generating deployment properties", (Throwable)e);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getDeploymentProperties(Class<?> declaringClass) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter writer = new PrintWriter(os);
            ((Writer)writer).write("className=" + declaringClass.getName() + "\n");
            for (String line : ConfigurationImpl.get().getExtraDeploymentProperties()) {
                ((Writer)writer).write(line + "\n");
            }
            ((Writer)writer).flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            os.close();
        }
    }

    public boolean isUnit() {
        return this.unit;
    }

    public void setUnit(boolean unit) {
        this.unit = unit;
    }

    public Class<? extends Throwable> getExpectedDeploymentException() {
        return this.expectedDeploymentException;
    }

    public void setExpectedDeploymentException(Class<? extends Throwable> expectedDeploymentException) {
        this.expectedDeploymentException = expectedDeploymentException;
    }

    public boolean isRunLocally() {
        return this.runLocally;
    }

    public void setRunLocally(boolean runLocally) {
        this.runLocally = runLocally;
    }
}

