/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.runner.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.testharness.api.TestResult;
import org.jboss.testharness.impl.ConfigurationImpl;
import org.jboss.testharness.impl.runner.TestResultImpl;
import org.jboss.testharness.impl.runner.TestRunner;
import org.testng.ITestResult;

public class ServletTestRunner
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String outputMode;
        ConfigurationImpl.get().setStandalone(false);
        TestRunner runner = new TestRunner();
        String methodName = null;
        if (req.getParameter("methodName") != null) {
            methodName = req.getParameter("methodName");
            runner.getMethodNames().add(methodName);
        }
        if ((outputMode = req.getParameter("outputMode") != null ? req.getParameter("outputMode") : "html").equals("serializedObject") && methodName == null) {
            resp.sendError(500, "No method name specified");
            return;
        }
        if (outputMode.equals("html")) {
            runner.run(false);
            resp.setContentType("text/html");
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("<html>\n");
            writer.write("<head><title>TCK Report</title></head>\n");
            writer.write("<body>\n");
            writer.write("<h2>Configuration</h2>\n");
            writer.write("<table>\n");
            writer.write("<tr>\n");
            writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
            writer.write("</tr>\n");
            for (ITestResult result : runner.getContext().getFailedConfigurations().getAllResults()) {
                ServletTestRunner.writeResult(writer, result);
            }
            for (ITestResult result : runner.getContext().getSkippedConfigurations().getAllResults()) {
                ServletTestRunner.writeResult(writer, result);
            }
            writer.write("</table>\n");
            writer.write("<h2>Tests</h2>\n");
            writer.write("<table>\n");
            writer.write("<tr>\n");
            writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
            writer.write("</tr>\n");
            for (ITestResult result : runner.getContext().getFailedTests().getAllResults()) {
                ServletTestRunner.writeResult(writer, result);
            }
            for (ITestResult result : runner.getContext().getPassedTests().getAllResults()) {
                ServletTestRunner.writeResult(writer, result);
            }
            for (ITestResult result : runner.getContext().getSkippedTests().getAllResults()) {
                ServletTestRunner.writeResult(writer, result);
            }
            writer.write("</table>\n");
            writer.write("</body>\n");
        } else if (outputMode.equals("serializedObject")) {
            runner.run(true);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)resp.getOutputStream());
            if (runner.getTestResults().size() == 1) {
                TestResult result = runner.getTestResults().get(0).getStatus() == 3 ? TestResultImpl.of(runner.getConfigurationResults().get(0)) : TestResultImpl.of(runner.getTestResults().get(0));
                oos.writeObject(result);
                resp.setStatus(200);
                oos.flush();
                oos.close();
            } else {
                resp.sendError(500, ">1 result!");
            }
        } else {
            resp.sendError(500, "No report format specified");
        }
    }

    private static void writeResult(PrintWriter writer, ITestResult result) {
        writer.write("<tr>\n");
        writer.write("<td>" + result.getMethod() + "</td>");
        writer.write("<td>" + ServletTestRunner.statusAsString(result.getStatus()) + "</td>");
        writer.write("</tr>\n");
        if (result.getStatus() == 2) {
            writer.write("<tr>\n");
            writer.write("<td colspan=\"2\"><pre>");
            result.getThrowable().printStackTrace(writer);
            writer.write("</pre></td>");
            writer.write("</tr>\n");
        }
    }

    private static String statusAsString(int statusCode) {
        switch (statusCode) {
            case 1: {
                return "success";
            }
            case 2: {
                return "failure";
            }
            case 3: {
                return "skipped";
            }
        }
        return "unknown";
    }
}

