package org.jboss.testharness.impl.packaging.ear;
import static org.jboss.testharness.impl.util.Reflections.loadResource;

import java.net.URL;

import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;

public class EjbJarArtifactDescriptor extends JSR299ArtifactDescriptor
{
   
   public static final String EJB_JAR_XML_DESTINATION = "META-INF/ejb-jar.xml";
   public static final String STANDARD_EJB_JAR_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/ear/ejb-jar.xml";
   public static final String CUSTOM_EJB_JAR_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/ear/custom-ejb-jar.xml";
   
   private final String ejbJarXml;
   
   public EjbJarArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName, String ejbJarXml)
   {
      super(declaringClass, beansXmlSourceFileName);
      this.ejbJarXml = ejbJarXml;
   }
   
   @Override
   public EjbJarArtifactDescriptor initialize()
   {
      super.initialize();
      if (ejbJarXml != null)
      {
         getResources().add(new ResourceDescriptorImpl(EJB_JAR_XML_DESTINATION, ejbJarXml));
      }
      else
      {
         URL ejbJarXml = loadResource(CUSTOM_EJB_JAR_XML_FILE_NAME);
         if (ejbJarXml == null)
         {
            ejbJarXml = loadResource(STANDARD_EJB_JAR_XML_FILE_NAME);
         }
         getResources().add(new ResourceDescriptorImpl(EJB_JAR_XML_DESTINATION, ejbJarXml));
      }
      
      return this;
   }
   
   @Override
   public String toString()
   {
      return "ejb jar, " + super.toString();
   }
   
   @Override
   public boolean isLibrariesSupported()
   {
      return false;
   }
   
}
