package org.jboss.testharness.impl.packaging.ear;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.jboss.testharness.impl.packaging.Resource;

/**
 * Override the default META-INF/ejb-jar.xml
 * 
 * @see Resource
 * 
 * @author Pete Muir
 *
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface EjbJarXml
{
   
   /**
    * Location of the overriding file, relative to the current location or the
    * root this classpath
    * 
    */
   String value();
   
}
