package org.jboss.testharness.impl.packaging.jsr299;

import static org.jboss.testharness.impl.util.Strings.isEmpty;

import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;

public class JSR299ArtifactDescriptor extends TCKArtifactDescriptor
{
   
   public static final String BEANS_XML_DESTINATION = "META-INF/beans.xml";
   public static final String STANDARD_BEANS_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/jsr299/default/beans.xml";
   
   private final ResourceDescriptor beansXml;
   
   public JSR299ArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName)
   {
      super(declaringClass);
      if (!isAddBeansXml())
      {
         this.beansXml = null;
      }
      else
      {
         if (isEmpty(beansXmlSourceFileName))
         {
            beansXmlSourceFileName = STANDARD_BEANS_XML_FILE_NAME;
         }
         this.beansXml = new ResourceDescriptorImpl(getBeansDestination(), beansXmlSourceFileName);
      }
   }
   @Override
   public JSR299ArtifactDescriptor initialize()
   {
      super.initialize();
      if (beansXml != null)
      {
         getResources().add(beansXml);
      }
      return this;
   }
   
   public String getBeansDestination()
   {
      return BEANS_XML_DESTINATION; 
   }
   
   public ResourceDescriptor getBeansXml()
   {
      return beansXml;
   }
   
   protected boolean isAddBeansXml()
   {
      return true;
   }
   
}
