package org.jboss.testharness.impl.packaging.jsr299;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;

import org.apache.log4j.Logger;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.impl.ConfigurationImpl;
import org.jboss.testharness.impl.packaging.ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.properties.PropertiesManager;

public class TCKArtifactDescriptor extends ArtifactDescriptor
{
   private static final Logger log = Logger.getLogger(TCKArtifactDescriptor.class);
   
   private boolean unit;
   private boolean runLocally;
   private Class<? extends Throwable> expectedDeploymentException;
   
   public TCKArtifactDescriptor(Class<?> declaringClass)
   {
      super(declaringClass);
      
   }
   
   @Override
   public TCKArtifactDescriptor initialize()
   {
      super.initialize();
      if (isLibrariesSupported())
      {
         getLibraries().add(new ResourceDescriptorImpl("testng.jar", "/lib/testng-jdk15.jar"));
         getLibraries().add(new ResourceDescriptorImpl("jboss-test-harness-api.jar", "/lib/jboss-test-harness-api.jar"));
         getLibraries().add(new ResourceDescriptorImpl("jboss-test-harness.jar", "/lib/jboss-test-harness.jar"));
         InputStream deploymentProperties = null;
         try
         {
            deploymentProperties = getDeploymentProperties(getDeclaringClass());
            getResources().add(new ResourceDescriptorImpl(getClassesRoot() + PropertiesManager.RESOURCE_BUNDLE, deploymentProperties));
         }
         catch (IOException e)
         {
            log.warn("Error generating deployment properties", e);
         }
         finally
         {
            if (deploymentProperties != null)
            {
               try
               {
                  deploymentProperties.close();
               }
               catch (IOException e)
               {
                  log.error("Error generating deployment properties", e);
               }
            }
         }
      }
      return this;
   }
   
   private static InputStream getDeploymentProperties(Class<?> declaringClass) throws IOException
   {
      ByteArrayOutputStream os = new ByteArrayOutputStream();
      try
      {
         Writer writer = new PrintWriter(os);
         writer.write("className=" + declaringClass.getName() + "\n");
         writer.write(Configuration.STANDALONE_PROPERTY_NAME + "=false\n");
         
         for (String line : ConfigurationImpl.get().getExtraDeploymentProperties())
         {
            writer.write(line + "\n");
         }
         writer.flush();
         return new ByteArrayInputStream(os.toByteArray());
      }
      finally
      {
         os.close();
      }
   }
   
   public boolean isUnit()
   {
      return unit;
   }
   
   public void setUnit(boolean unit)
   {
      this.unit = unit;
   }
   
   public Class<? extends Throwable> getExpectedDeploymentException()
   {
      return expectedDeploymentException;
   }
   
   public void setExpectedDeploymentException(Class<? extends Throwable> expectedDeploymentException)
   {
      this.expectedDeploymentException = expectedDeploymentException;
   }
   
   public boolean isRunLocally()
   {
      return runLocally;
   }
   
   public void setRunLocally(boolean runLocally)
   {
      this.runLocally = runLocally;
   }
   
}
