package org.jboss.testharness.impl.packaging.war;
import static org.jboss.testharness.impl.util.Reflections.loadResource;

import java.net.URL;

import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;

public class WarArtifactDescriptor extends JSR299ArtifactDescriptor
{
   
   public static final String WEB_XML_DESTINATION = "WEB-INF/web.xml";
   public static final String STANDARD_WEB_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/war/web.xml";
   public static final String CUSTOM_WEB_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/war/custom-web.xml";
   
   public WarArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName)
   {
      super(declaringClass, beansXmlSourceFileName);
   }
   
   @Override
   public WarArtifactDescriptor initialize()
   {
      super.initialize();
      URL webXml = loadResource(CUSTOM_WEB_XML_FILE_NAME);
      if (webXml == null)
      {
         webXml = loadResource(STANDARD_WEB_XML_FILE_NAME);
      }
      getResources().add(new ResourceDescriptorImpl(WEB_XML_DESTINATION, webXml));
      return this;
   }
   
   @Override
   public String getClassesRoot()
   {
      return "WEB-INF/classes/";
   }
   
   @Override
   public String toString()
   {
      return "war, " + super.toString();
   }
   
   @Override
   public String getExtension()
   {
      return ".war";
   }
   
   @Override
   public boolean isLibrariesSupported()
   {
      return true;
   }
   
   @Override
   protected String getLibrariesRoot()
   {
      return "WEB-INF/lib";
   }
   
   @Override
   public String getBeansDestination()
   {
      return "WEB-INF/beans.xml";
   }
}
