package org.jboss.testharness.impl.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jboss.testharness.impl.testng.RemoveExpectedExceptionsAnnotationTransformer;
import org.jboss.testharness.properties.PropertiesManager;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestRunner
{
   
   private Set<String> classNames;
   private List<String> methodNames;
   private ITestContext context;
   private List<ITestResult> testResults;
   private List<ITestResult> configurationResults;
   
   public TestRunner()
   {   
      methodNames = new ArrayList<String>();
      classNames = new HashSet<String>();
      
   }
   
   public Set<String> getClassNames()
   {
      return classNames;
   }
   
   public List<String> getMethodNames()
   {
      return methodNames;
   }
   
   public void run(boolean ignoreExpectedExceptions)
   {
      if (classNames.size() == 0)
      {
         PropertiesManager propertiesManager = new PropertiesManager();
         this.classNames = propertiesManager.getPropertyValues("className");
      }
      TestNG testNG = new TestNG(false);
      testNG.setVerbose(0);
      BufferedListener listener = new BufferedListener();
      testNG.addListener(listener);
      List<XmlSuite> xmlSuites = new ArrayList<XmlSuite>();
      testNG.setXmlSuites(xmlSuites);
      xmlSuites.add(createSuite());
      if (ignoreExpectedExceptions)
      {
         testNG.setAnnotationTransformer(new RemoveExpectedExceptionsAnnotationTransformer());
      }
      testNG.run();
      this.context = listener.getContext();
      this.testResults = listener.getTestResults();
      this.configurationResults = listener.getConfigurationResults();
   }
    
   
   private XmlSuite createSuite()
   {
      XmlSuite suite = new XmlSuite();
      suite.setName("JSR-299 TCK");
      suite.setAnnotations("JDK5_ANNOTATION_TYPE");
      for (String className : classNames)
      {
         XmlTest test = new XmlTest(suite);
         test.setName("JSR-299 TCK" + className);
         List<XmlClass> testClasses = new ArrayList<XmlClass>();
         XmlClass testClass = new XmlClass(className);
         for (String methodName : getMethodNames())
         {
            testClass.getIncludedMethods().add(methodName);
         }
         testClasses.add(testClass);
         test.setXmlClasses(testClasses);
      }
      return suite;
   }
   
   public ITestContext getContext()
   {
      return context;
   }
   
   public List<ITestResult> getTestResults()
   {
      return testResults;
   }
   
   public List<ITestResult> getConfigurationResults()
   {
      return configurationResults;
   }
   
}
